/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: SimFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1994/11/21 14:44:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to control the running simulations.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: SimFormsObj.h,v $
 * Revision 1.2  1994/11/21  14:44:37  billh
 * Bracketed .C and .h files in checks for having VMDREMOTE defined.
 *
 * Revision 1.1  94/10/21  03:49:26  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef SIMFORMSOBJ_H
#define SIMFORMSOBJ_H

#ifdef VMDREMOTE

#include "FormsObj.h"


class SimFormsObj : public FormsObj {

private:
  // reset the selection browser
  void reset_sim_selection(void);
  
  // reset the parameter browser based on the top simulation
  void reset_parameters(void);
  
  // flag for whether a parameter is being changed, and routine to change
  // between doing this and not
  int editParam;		// if < 0, not being changed
  void set_edit_parameter(int);	// if arg < 0, return to not editing
  
  // update patch display method selector, if applicable
  void reset_patch_display(void);

  // update sim status display
  void reset_sim_status(void);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  SimFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);
  virtual ~SimFormsObj(void) { }

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

  // update the interface display for each screen redraw
  virtual void update(void);

};

#endif

#endif
