/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Residue.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1994/11/28 03:58:34 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  This is based on the uniq_resid assigned in BaseMolecule
 * A residue knows the other residues to which it is connected.  It also
 * has a list of all the atoms contained by this residue
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Residue.h,v $
 * Revision 1.3  1994/11/28  03:58:34  dalke
 * added names for secondary structure
 *
 * Revision 1.2  1994/11/26  07:40:59  dalke
 * Now know about "its" atoms
 *
 * Revision 1.1  1994/11/25  23:32:16  dalke
 * Initial revision
 *
 ***************************************************************************/

#ifndef RESIDUE_H
#define RESIDUE_H

#include "Inform.h"
#include "Atom.h" // to get enums from Atom
#include "ResizeArray.h"


class Residue {
  public:
    enum BondType { PRO_PRO, NUC_NUC, OTHER };
    enum SStruct { HELIX, SHEET, TURN, COIL };
      
    enum { MAXRESIDUEBONDS = 4 };
    
    int idx;
    int resid; // the "real" resid
    Atom::ResidueType residueType;
    int bonds;
    int bondTo[MAXRESIDUEBONDS];
    BondType bondType[MAXRESIDUEBONDS];
    ResizeArray<int> atoms;
    int fragment;
    SStruct sstruct;

    Residue(int id, int realid, Atom::ResidueType newtype) : atoms(4) {
      idx = id;
      resid = realid;
      bonds = 0;
      residueType = newtype;
      fragment = -1;
    }
    void add_atom(int atomindex) {
      atoms.append(atomindex);
    };
    
    void add_bond(int bondto) {
      int j;
      int flg = FALSE;
//      msgInfo << "checking bond from " << idx << " to " << bondto << sendmsg;
      for (j=0; j<bonds; j++) { // check uniqueness
        if (bondTo[j] == bondto) { // already there
          flg = TRUE;
          break;  // ignore repeats;  I would have a return, but the
                  // compilier doesn't allow that in inline functions
        }
      }  // new bond
      if (!flg && idx != bondto) { 
//        msgInfo << "Adding bond." << sendmsg;
        if (bonds >= MAXRESIDUEBONDS) {
          msgErr << "Uniq Residue exceeded maximim number of bonds (";
          msgErr << bonds << ")." << sendmsg;
        } else {
          bondTo[bonds++] = bondto;
        }
      }
    } // end of add_bond
    

};

#endif
