/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: RemoteList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/21 03:49:26 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A list of the currently and previously remotely connected simulations.
 * These are also Molecules, which are also stored in the MoleculeList
 * object.  However, this is not a Displayable object.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: RemoteList.h,v $
 * Revision 1.1  1994/10/21  03:49:26  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef REMOTELIST_H
#define REMOTELIST_H

#include "MoleculeRemote.h"
#include "ResizeArray.h"
#include "utilities.h"


class RemoteList {

private:
  // the 'top' remote connection, which is used to determine for which remote
  // connection commands are executed.
  int topRemote;
  
  // remote molecules in this list
  ResizeArray<MoleculeRemote *> remList;
  
public:
  // constructor and destructor
  RemoteList(void);
  ~RemoteList(void) { }
  
  // return number of remote connections being stored
  int num(void) { return remList.num(); }
  
  // return the Nth remote connection (index runs 0 ... (count-1))
  MoleculeRemote *remote(int n) {
    MoleculeRemote *retval = NULL;
    if(n >= 0 && n < num())
      retval = remList[n];
    return retval;
  }
  
  // return the index of the remote molecule with given ID (-1 if error)
  int rem_index_from_id(int);

  // return the index of the given remote molecule (-1 if error)
  int rem_index(MoleculeRemote *m) { return remList.find(m); }

  // add a new remote mol; return it's position in remList, or (-1) if error
  int add_molecule(MoleculeRemote *);

  // remove the Nth rem molecule from the list, i.e. delete it.  Return success
  int del_molecule(int);

  // return the top remote molecule
  MoleculeRemote *top(void) {
    MoleculeRemote *retval = NULL;
    if(topRemote >= 0)
      retval = remList[topRemote];
    return retval;
  }

  // query or set the top remote molecule
  int is_top(int n) { return (n == topRemote); }
  int is_top(MoleculeRemote *m) { return m == top(); }
  int make_top(MoleculeRemote *m) { return make_top(rem_index(m)); }
  int make_top(int n);

};

#endif
