/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ReadPSF.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/09/17 09:11:36 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Routines to read .psf files.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ReadPSF.h,v $
 * Revision 1.1  1994/09/17  09:11:36  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef READ_PSF_H
#define READ_PSF_H

#include <stdio.h>
#include "utilities.h"

#define PSF_RECORD_LENGTH	80

/* Open the .psf file and skip past the remarks to the first data section.
   Returns the file pointer, or NULL if error.  Also puts the number of
   atoms in the molecule into the given integer.  If fname is an empty string,
   this will use standard input. */
FILE *open_psf_file(char *, int *);

/* Read in the next atom info into the given storage areas; this assumes
   that file has already been moved to the beginning of the atom records.
   Returns the serial number of the atom. If there is an error, returns -1.*/
int get_psf_atom(FILE *, char *, char *, char *, char *, int *, float *, 
   float *);

/* Read in the beginning of the bond information, but don't read in the 
   bonds.  Returns the number of bonds in molecule.  If error, returns (-1). */
int start_psf_bonds(FILE *);

/* Read in the bond info into the given integer arrays, one for 'from' and
   one for 'to' atoms; remember that .psf files use 1-based indices,
   not 0-based.  Returns TRUE if all nbond bonds found; FALSE otherwise.  */
int get_psf_bonds(FILE *, int, int[], int[]);


#endif

