/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ReadEDM.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   for the code to read in an electron density map
 * also, the edm data type
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ReadEDM.h,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/

#ifndef READEDM_H
#define READEDM_H
#include <stddef.h>
#include "Grid.h"

typedef struct edm_t{
   float minx, miny, minz;   // 0, 0, 0
   float maxx, maxy, maxz;   // a, b, c
   float alpha, beta, gamma;
   Grid<float> *grid;
   edm_t(void) {
      grid = NULL;
   }
   ~edm_t(void) {
      if (grid) {
	 delete grid;
      }
   }
};

edm_t *read_edm(char *filename);
#endif
