/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ReadEDM.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code to read an electron density file, as specified on p211 of
 * the XPLOR 3.1 manual, but made to reflect the format I see in the
 * actual file, which seems to differ.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ReadEDM.C,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/ReadEDM.C,v 1.1 1995/02/12 07:24:14 dalke Exp $";
#endif

#include <stdio.h>
#include <strings.h>
#include "ReadEDM.h"

//  Here's what I believe an electron density map looks like
//
//  <blank lines>
//     <int number of header lines> <junk>
//     <header line 1>
//     <header line 2> ...
//  <numx> <minx> <maxx> <numy> <miny> <maxy> <numz> <minz> <maxz>
//  <a> <b> <c> <alpha> <beta> <gamma>
//  XYZ
//  0
//  <numx*numy density numbers .....>
//  1
//  <numx*numy density numbers .....>
//  ...
//    -9999

// From what I've seen, numx (y, or z) should be maxx - minx
// but the example data files indicate that if minx < 0 then
// numx = maxx - minx - 1.  Huh?!  So I'll force my
// numx = maxx - minx + 1 and do it my way.

  // given a filename, return the info contained therein
  // or return NULL.  Remember to delete, please
edm_t *read_edm(char *filename)
{
   FILE *infile = fopen(filename, "r");
   edm_t edm;
   if (!infile) {
//      fprintf(stderr, "Cannot open\n");
      return NULL;
   }
   int skip;
   if (! fscanf(infile, "%d", &skip)) {
//      fprintf(stderr, "Cannot get lines to skip\n");
      fclose(infile);
      return NULL;
   }
   skip++;  // get the rest of the !NTITLE line
   char buf[513];
   while (skip--) {
      fgets(buf, 512, infile);
//      fprintf(stderr, "missed: %s\n", buf);
   }
   int numx, numy, numz;
   {
      int minx, maxx, miny, maxy, minz, maxz;
      fgets(buf, 512, infile);
//   fprintf(stderr, "Trying: %s\n", buf);
      if (sscanf(buf, "%d %d %d %d %d %d %d %d %d\n", &numx, &minx, 
		 &maxx,  &numy, &miny, &maxy, &numz, &minz, &maxz) != 9) {
//      fprintf(stderr, "not able to read grid dimensions\n");
	 fclose(infile);
	 return NULL;
      }
      numx = maxx - minx + 1;  // override some of the read in values
      numy = maxy - miny + 1;  // because it doesn't work otherwise
      numz = maxz - minz + 1;  // with XPLOR generated data
   }

   if (fscanf(infile, "%f %f %f %f %f %f\n", &edm.maxx, &edm.maxy,
	      &edm.maxz, &edm.alpha, &edm.beta, &edm.gamma ) != 6) {
      fprintf(stderr, "Not able to read crystal dimensions\n");
      fclose(infile);
      return NULL;
   }
   edm.minx = edm.miny = edm.minz = 0.0;

   fgets(buf, 512, infile);  // should be "XYZ"
   if (!strcmp(buf, "XYZ")) {
      fprintf(stderr, "Unable to read format %s\n", buf);
      fclose(infile);
      return NULL;
   }

   // start reading data and putting it into the
   // grid
   Grid<float> *grid = new Grid<float>(numx, numy, numz);
   int tmpint;
   for (int k=0; k<numz; k++) {  // Z is the slowest
      fscanf(infile, "%d\n", &tmpint); // get a stupid counter
//      fprintf(stdout, "Found %d\n", tmpint);
      for (int j=0; j<numy; j++) {
	 for (int i=0; i<numx; i++) {
//	    fprintf(stderr, "%d %d %d ", i, j, k);
	    if (!fscanf(infile, "%12f", &(grid->item(i,j,k)))){
//	       fprintf(stderr, "%f\n", grid->item(i,j,k));
	       delete grid;
	       fclose(infile);
	       // fprintf(stderr, "Not enough data\n");
	       return NULL;
	    } else {
//	       fprintf(stderr, "%12f \n", grid->item(i,j,k));
	    }
	 }
      }
   }
   // the last thing should be 9999.9999, or something like that,
   // so check that I made it there.
   float f, g;
   fscanf(infile, "%f", &g); f = g;
   f = f + 9999;
   if (f < 0 ) f = -f;
   if (f > 0.001) {
      fprintf(stderr, "Couldn't find end of file marker\n");
      fprintf(stderr, "Found %f instead\n", g);
      fclose(infile);
      delete grid;
      return NULL;
   }

   // looks like it is all a-okay - yippee.
   fclose(infile);
   edm_t *tempedm = new edm_t;
   *tempedm = edm;
   tempedm->grid = grid;
}
