/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFilePSF.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   read in a psf
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MoleculeFilePSF.C,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/MoleculeFilePSF.C,v 1.1 1995/02/12 07:24:14 dalke Exp $";
#endif

#include "MoleculeFilePSF.h"
#include "ReadPSF.h"

MoleculeFilePSF::MoleculeFilePSF(char *filename, Scene *sc)
: MoleculeFile(filename, sc)
{
}
MoleculeFilePSF::MoleculeFilePSF(char *filename, Displayable *disp)
: MoleculeFile(filename, disp)
{
}
MoleculeFilePSF::~MoleculeFilePSF(void)
{
}

int MoleculeFilePSF::create(void){
   // read structure from psf file
   if(!(createFromPSF(strFile))) {
      return FALSE;
   }
   set_name(strName);  // save the file name
   
   return(Molecule::create());
}

// read in a molecule structure from the specified .psf file.
// Return TRUE if molecule was successfully read, FALSE if there is an error
int MoleculeFilePSF::createFromPSF(char *psffile) {

  FILE *psf;
  int natoms, nbonds, i, *from, *to, rid;
  char names[8], rnames[8], segnames[8], atypes[8], ridstr[8];
  float charges, masses, newpos[ATOMCOORDS], newdata[ATOMEXTRA];

  // first read the .psf for structure info
  if(!(psf = open_psf_file(psffile,&natoms))) {
    msgErr << "Cannot open structure file '" << psffile << "'." << sendmsg;
    return FALSE;
  }

  MSGDEBUG(2,"MoleculeFile: Creating structure from .psf" << sendmsg);

  // initialize data arrays that are used to create new atoms
  for(i=0; i < ATOMCOORDS; newpos[i++] = 0.0);
  newdata[ATOMBETA] = default_beta();
  newdata[ATOMOCCUP] = default_occup();
  newpos[0] = newpos[1] = newpos[2] = 0.0;

  MSGDEBUG(2,"   Reading " << natoms << " atoms ..." << sendmsg);

  // read in the atom structure info first
  init_atoms(natoms);
  for(i = 0; i < natoms; i++) {
    if(get_psf_atom(psf, names, atypes, rnames, segnames, &rid, &charges,
    		&masses) < 0) {
      msgErr << "Problem encountered while reading atom " << i;
      msgErr << " from structure file." << sendmsg;
      return FALSE;
    }
    if(rid < 10000000)
      sprintf(ridstr,"%d",rid);
    else
      strcpy(ridstr,"*******");
    newdata[ATOMCHARGE] = charges;
    newdata[ATOMMASS] = masses;
    newdata[ATOMRAD] = default_radius(names);
    add_atom(names, atypes, rnames, ridstr, segnames, newpos, newdata);
  }
  
  // now read bond data
  nbonds = start_psf_bonds(psf);

  MSGDEBUG(2,"   Reading " << nbonds << " bonds ..." << sendmsg);

  from = new int[nbonds];
  to = new int[nbonds];

  if(!get_psf_bonds(psf,nbonds,from,to)) {
    msgErr << "Problem encountered while reading bond data";
    msgErr << " from structure file." << sendmsg;
    delete [] to;
    delete [] from;
    return FALSE;
  }

  // add bonds to current structure
  for(i=0; i < nbonds; i++)
    add_bond(from[i] - 1, to[i] - 1);
    
  delete [] to;
  delete [] from;

  fclose(psf);

  MSGDEBUG(2,"Finished reading .psf" << sendmsg);

  return TRUE;
}
