/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFileGraph.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read in (x,y,z) from a file to plot 2d scalar graphs
 * 
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MoleculeFileGraph.h,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/

// the input format is
// minx maxx miny maxy nx ny
// data(0,0)
// data(0,1)
// ...
// data(0,ny-1)
// data(1,0)
// ...
// data(nx-1, ny-1)

// (the info can be on the same line -- whitespace delimited)

#ifndef MOLECULEFILEGRAPH_H
#define MOLECULEFILEGRAPH_H
#include "MoleculeFile.h"
#include "Grid.h" // but only used for 2D (with numz = 1)

class MoleculeFileGraph : public MoleculeFile
{
 private:
   // read in the (x,y,z) info and store in local space
   Grid<float> *grid;
   float minx, miny, minz, maxx, maxy, maxz;
   float mindata, maxdata;
 public:
   MoleculeFileGraph(char *filename, Scene *);
   MoleculeFileGraph(char *filename, Displayable *);
   virtual ~MoleculeFileGraph(void);

   // creates the molecule, calls the parent's create, and returns success
   virtual int create(void);
   virtual void create_cmdlist(void);

   // functions to "normalize" the picture  -- for a centering
   // translation and a scaling
   virtual void cov(float &x, float &y, float &z) {
      x = (minx + maxx)/2;
      y = (miny + maxy)/2;
      z = (minz + maxz)/2;
   }
   virtual float scale_factor(void) {
      float wx = maxx - minx;
      float wy = maxy - miny;
      float wz = maxz - minz;
      if (wx > wy) {
	 if (wx > wz) {
	    return 2.0/wx;
	 } else {
	    return 2.0/wz;
	 }
      } else {
	 if (wy > wz) {
	    return 2.0/wy;
	 } else {
	    return 2.0/wz;
	 }
      }
   }
};

#endif
