/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFileEDM.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read 3D scalar information from an electron density map file
 *  This can be used to draw isosurfaces
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MoleculeFileEDM.h,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/

#ifndef MOLECULEFILEEDM_H
#define MOLECULEFILEEDM_H
#include "MoleculeFile.h"
#include "ReadEDM.h"
#include "ResizeArray.h"

class MoleculeFileEDM : public MoleculeFile
{
 private:
  // read in the molecular data from the specified PSF file
  edm_t *edm;


  void find_isosurface(float );  // redo the drawing list
     // to make the specified isosurface

 public:
  MoleculeFileEDM(char *, Scene *);
  MoleculeFileEDM(char *, Displayable *);
  virtual ~MoleculeFileEDM(void);
  
  // creates the molecule and returns success - also calls
  // the parent class create routines
  virtual int create(void);

  // this will be changed to make things more useful
  virtual void create_cmdlist(void) {
     find_isosurface(0.90);
  }

  // I'm thinking of things like displaying multiple isosurfaces
  // and such, but that call for a pretty large change in the code
  virtual int add_rep(AtomColor *, AtomRep *, AtomSel *);
  virtual int change_rep(int n, AtomColor *, AtomRep *, AtomSel *);

  virtual void cov(float &x, float &y, float &z) {
     if (edm) {
	x = (edm->minx + edm->maxx)/2.0;
	y = (edm->miny + edm->maxy)/2.0;
	z = (edm->minz + edm->maxz)/2.0;
     } else {
	x = y = z = 0.0;
     }
  }
  // scaling factor required to make the grid fit within (-1 ... 1)
  virtual float scale_factor(void) { 
     float wx = edm->maxx - edm->minx;
     float wy = edm->maxy - edm->miny;
     float wz = edm->maxz - edm->minz;
     if (wx > wy) {
	if (wx > wz) {
	   return 2.0/wx;
	} else {
	   return 2.0/wz;
	}
     } else {
	if (wy > wz) {
	   return 2.0/wy;
	} else {
	   return 2.0/wz;
	}
     }
  }

};

#endif
