/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFile.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/02/12 07:21:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MoleculeFile is inherited from Molecule, and supplies routines to 
 * create a molecule by reading data from a file.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MoleculeFile.C,v $
 * Revision 1.5  1995/02/12  07:21:11  dalke
 * moved PDB and PSF reads into seperate objects, making a "Molecule"
 * be much more general.
 *
 * Revision 1.4  1994/11/22  02:34:56  billh
 * Changed to not require StructureFile enum as type of argument to constructor.
 *
 * Revision 1.3  94/11/02  07:32:48  billh
 * Fixed bug preventing proper selection by resid.
 * 
 * Revision 1.2  1994/09/30  05:36:18  billh
 * Added externally-available string arrays for file type extensions.
 *
 * Revision 1.1  1994/09/17  09:11:36  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/MoleculeFile.C,v 1.5 1995/02/12 07:21:11 dalke Exp $";
#endif

#include <math.h>
#include <string.h>
#include <ctype.h>
#include "MoleculeFile.h"
#include "Atom.h"
#include "utilities.h"


// string file extensions for the different known structure files
char *structureFileTypeNames[MoleculeFile::STRTYPES] = {
	"psf", "pdb", "edm", "graph", "raster3d"};


/////////////////////////////////////////////////////////////////////
// class constructor ... specifies the filename and either,
// a Scene or Displayable
MoleculeFile::MoleculeFile(char *fname, Scene *sc) : Molecule("File", sc) {
  do_construct(fname);
}

// this version uses a Displayable instead of Scene, so that it becomes a
// child Displayable to some parent.
MoleculeFile::MoleculeFile( char *fname, Displayable *dp) :
        Molecule("File", dp) {
  do_construct(fname);
}


// do main constructor tasks
void MoleculeFile::do_construct( char *fname) {
  strFile = stringdup(fname);
  breakup_filename(strFile, &strPath, &strName);
  blankname[0] = '\0';
  
  MSGDEBUG(1,"Creating MoleculeFile, file='" << fname << "'");
}


MoleculeFile::~MoleculeFile(void) {
  MSGDEBUG(1,"Deleting MoleculeFile ..." << sendmsg);

  if(strFile)  delete [] strFile;
  if(strPath)  delete [] strPath;
  if(strName)  delete [] strName;
}
