/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Molecule.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1994/11/22 02:34:50 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Main Molecule objects, which contains all the capabilities necessary to
 * store, draw, and manipulate a molecule.  This adds to the functions of
 * DrawMolecule and BaseMolecule by adding routines to read and write various
 * coordinate files.
 *
 * Note: Other capabilities, such as writing structure files, mutations, etc.
 * should go into this level.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Molecule.h,v $
 * Revision 1.4  1994/11/22  02:34:50  billh
 * Now reads and writes coordinate files using CoorFileData class, and
 * can use a begframe, endframe, frameskip pattern for both read and write.
 *
 * Revision 1.3  94/10/05  21:45:01  billh
 * Changed to use a ResizeArray instead of linked list.
 * 
 * Revision 1.2  1994/09/30  05:36:18  billh
 * Added externally-available string arrays for file type extensions.
 *
 * Revision 1.1  1994/09/17  09:11:36  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef MOLECULE_H
#define MOLECULE_H

#include "DrawMolecule.h"
#include "ResizeArray.h"
#include "CoorFileData.h"
#include "utilities.h"


class Molecule : public DrawMolecule {

public:
  // where did this molecule come from?
  char *source;

private:
  // Coordinate files we are supposed to read/write.  Only one will be accessed
  // at a time, though, so we must maintain a list.
  ResizeArray<CoorFileData *> coorIOFiles;
  
public:
  // constructor ... nothing much to do, just save the source, and pass on
  // the other data.
  Molecule(char *, Scene *);
  Molecule(char *, Displayable *);
  
  // destructor ... just clear out unread files
  virtual ~Molecule(void);
  
  // no need for create routine here ... there is nothing for this
  // level to create.

  //
  // requests to process files
  //

  // ask to read in a coordinate file of the specified type
  // arguments: filename, type, beginning frame, ending frame, frame skip
  // (if any of the last three are < 0, default values for that arg used)
  // return succes.
  int read_coor_file(char *, int, int=(-1), int=(-1), int=(-1));

  // ask to write out a coordinate file of the specified type
  // arguments: filename, type, beginning frame, ending frame, frame skip
  // (if any of the last three are < 0, default values for that arg used)
  // return succes.
  int write_coor_file(char *, int, int=(-1), int=(-1), int=(-1));

  //
  // public virtual routines for Displayable
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  // This possibly reads a new timestep, if requested.
  virtual void prepare(DisplayDevice *);

};

#endif
