/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MolFormsObj.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1994/10/05 04:38:23 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to list current molecules, and to add/delete them.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MolFormsObj.C,v $
 * Revision 1.3  1994/10/05  04:38:23  billh
 * Took out double backslash from text, even in comments.
 *
 * Revision 1.2  1994/10/01  10:45:13  billh
 * Added check for REMOTE_RUN and REMOTE_ATTACH commands.
 *
 * Revision 1.1  1994/09/29  20:58:55  billh
 * Initial revision
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/MolFormsObj.C,v 1.3 1994/10/05 04:38:23 billh Exp $";
#endif

#include <stdio.h>
#include "MolFormsObj.h"
#include "MoleculeList.h"
#include "CmdMol.h"
#include "Global.h"

// commands we are interested in
static int numCmds = 5;
static int cmdList[5] = {
	Command::MOL_ACTIVE,		Command::MOL_FIX,
	Command::MOL_ON,		Command::REMOTE_RUN,
	Command::REMOTE_ATTACH };

/////////////////////////  constructor  
MolFormsObj::MolFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("mol", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = molMenu;
  lightButton = mol_menu_button;
  offButton = mol_menu_off;
  
  // register which commands we are interested in
  for(int i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  // turn on if required
  if(sh)
    On();
}

/////////////////////////  private routines  

// set the state of the molecule browser
void MolFormsObj::reset_mol_browser(void) {
  char molstr[256];
  Molecule *mol;

  if(!moleculeList) {
    fl_clear_browser(mol_browser);
    return;
  }

  freeze();
  
  fl_clear_browser(mol_browser);
  for(int i=0; i < moleculeList->num(); i++) {
    mol = moleculeList->molecule(i);
    sprintf(molstr, "%c%c%c%c  %33s%7d  %s",
    	(moleculeList->is_top(i) ? 'T' : ' '),
	(moleculeList->active(i) ? 'A' : ' '),
	(moleculeList->displayed(i) ? 'D' : ' '),
	(moleculeList->fixed(i) ? 'F' : ' '),
	mol->name, mol->nAtoms, mol->source);
    fl_add_browser_line(mol_browser, molstr);
  }
    
  unfreeze();
}

//////////////////////  protected virtual routines  

// routine to check the main form for use
int MolFormsObj::check(FL_OBJECT *obj) {

  if(obj == mol_browser) {
    // do nothing

  } else if(obj == active_all) {
    addcommand(new CmdMolActive(-1, TRUE, id()));

  } else if(obj == active_none) {
    addcommand(new CmdMolActive(-1, FALSE, id()));
  
  } else if(obj == active_toggle) {
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        // toggle the active status of this molecule
	addcommand(new CmdMolActive((moleculeList->molecule(i))->id(),
		! moleculeList->active(i), id()));
      }
    }
    
  } else if(obj == display_all) {
    addcommand(new CmdMolOn(-1, TRUE, id()));
    
  } else if(obj == display_none) {
    addcommand(new CmdMolOn(-1, FALSE, id()));
    
  } else if(obj == display_toggle) {
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        // toggle the displayed status of this molecule
	addcommand(new CmdMolOn((moleculeList->molecule(i))->id(),
		! moleculeList->displayed(i), id()));
      }
    }
    
  } else if(obj == fixed_all) {
    addcommand(new CmdMolFix(-1, TRUE, id()));
    
  } else if(obj == fixed_none) {
    addcommand(new CmdMolFix(-1, FALSE, id()));
    
  } else if(obj == fixed_toggle) {
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        // toggle the fixed status of this molecule
	addcommand(new CmdMolFix((moleculeList->molecule(i))->id(),
		! moleculeList->fixed(i), id()));
      }
    }

  } else if(obj == make_top_button) {
    // make the first selected molecule the top one
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {      
        addcommand(new CmdMolTop((moleculeList->molecule(i))->id(), id()));
        break;
      }
    }

  } else if(obj == single_mol_button) {
    // make the first selected molecule the ONLY active, displayed, top one
    addcommand(new CmdMolActive(-1, FALSE, id()));
    addcommand(new CmdMolOn(-1, FALSE, id()));
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {      
        addcommand(new CmdMolActive((moleculeList->molecule(i))->id(), id()));
        addcommand(new CmdMolOn((moleculeList->molecule(i))->id(), id()));
        addcommand(new CmdMolTop((moleculeList->molecule(i))->id(), id()));
	break;
      }
    }

  } else if(obj == mol_delete) {
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        // toggle the fixed status of this molecule
	addcommand(new CmdMolDelete((moleculeList->molecule(i))->id(), id()));
      }
    }
    
  } else
    return FALSE;

  return TRUE;
}


// do form-specific acting on commands.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
// here, don't need this, just take parent class version
int MolFormsObj::forms_act_on_command(int type, Command *, int) {

  MSGDEBUG(3,"MolFormsObj: acting on command " << type << sendmsg);

  // check all the possible commands that we look for ...
  // base class already takes care of new, del, and top
  if(type == Command::MOL_ACTIVE || type == Command::MOL_ON ||
  		type == Command::MOL_FIX || type == Command::REMOTE_RUN ||
		type == Command::REMOTE_ATTACH) {
    reset_mol_browser();

  } else
    // unknown command type
    return FALSE;
    
  return TRUE;
}


//////////////////////  public virtual routines  

// initialize the user interface
void MolFormsObj::init(void) {
  freeze();
    // set all the basic values for controllers, etc
    fl_set_browser_fontstyle(mol_browser,FL_FIXED_STYLE);
    fl_clear_browser(mol_browser);
   
    // do a reset to set initial values
    reset();

  unfreeze();
}


// reset the user interface
void MolFormsObj::reset(void) {
  freeze();
    reset_mol_browser();
  unfreeze();
}
