/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MolAction.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/20 01:30:58 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MolAction object is something which performs an 'act' for a Molecule
 * object.  For example, it may change the bond radius or display all
 * alpha carbons.  It is used by the MoleculeList object to perform an
 * action on a list of objects.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MolAction.h,v $
 * Revision 1.1  1994/10/20  01:30:58  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef MOLACTION_H
#define MOLACTION_H

#include "Molecule.h"


// defines for setting the current frame to the beginning or end
#define SET_FRAME_START		(-1)
#define SET_FRAME_END		(-2)


////////////////////////////  MolAction base class  \\\\\\\\\\\\\\\\\\\

class MolAction {

public:
  MolAction(void) { }
  virtual ~MolAction(void) { }

  // virtual routine which each subclass replaces with the particular action
  // they want done
  virtual void act(Molecule *) { }

};

////////////////////////////  inherited MolAction classes  \\\\\\\\\\\\\\\\\\\

// MolPause
class MolPause : public MolAction {
public:
  MolPause(void) { }
  virtual ~MolPause(void) { }
  virtual void act(Molecule *m) { m->anim_dir(Animation::PAUSE); }
};

// MolReverse
class MolReverse : public MolAction {
public:
  MolReverse(void) { }
  virtual ~MolReverse(void) { }
  virtual void act(Molecule *m) { m->anim_dir(Animation::REVERSE); }
};

// MolReverse1
class MolReverse1 : public MolAction {
public:
  MolReverse1(void) { }
  virtual ~MolReverse1(void) { }
  virtual void act(Molecule *m) { m->anim_dir(Animation::REVERSE1); }
};

// MolForward
class MolForward : public MolAction {
public:
  MolForward(void) { }
  virtual ~MolForward(void) { }
  virtual void act(Molecule *m) { m->anim_dir(Animation::FORWARD); }
};

// MolForward1
class MolForward1 : public MolAction {
public:
  MolForward1(void) { }
  virtual ~MolForward1(void) { }
  virtual void act(Molecule *m) { m->anim_dir(Animation::FORWARD1); }
};

// MolSetFrame
class MolSetFrame : public MolAction {
private:
  int val;
public:
  MolSetFrame(int s) { val = s; }
  virtual ~MolSetFrame(void) { }
  virtual void act(Molecule *m) {
    if(val == SET_FRAME_START)
      m->goto_frame(0);
    else if(val == SET_FRAME_END)
      m->goto_frame(m->num() - 1);
    else
      m->goto_frame(val);
  }
};

// MolSetSkip
class MolSetSkip : public MolAction {
private:
  int val;
public:
  MolSetSkip(int s) { val = s; }
  virtual ~MolSetSkip(void) { }
  virtual void act(Molecule *m) { m->skip(val); }
};

// MolAnimStyle
class MolAnimStyle : public MolAction {
private:
  Animation::AnimStyle newstyle;
public:
  MolAnimStyle(Animation::AnimStyle ns) { newstyle = ns; }
  virtual ~MolAnimStyle(void) { }
  virtual void act(Molecule *m) { m->anim_style(newstyle); }
};

// MolSetSpeed
class MolSetSpeed : public MolAction {
private:
  float speed;
public:
  MolSetSpeed(float s) { speed = s; }
  virtual ~MolSetSpeed(void) { }
  virtual void act(Molecule *m) { m->speed(speed); }
};

////////////////////////////////////////////////////////////////////



// MolPickAdd
class MolPickAdd : public MolAction {
public:
  MolPickAdd(void) { }
  virtual ~MolPickAdd(void) { }
//  virtual MolAction& act(Molecule *m) { m->pick_add(); return *this; }
};

// MolPickDelete
class MolPickDelete : public MolAction {
public:
  MolPickDelete(void) { }
  virtual ~MolPickDelete(void) { }
//  virtual MolAction& act(Molecule *m) { m->pick_delete(); return *this; }
};

// MolClearPicklist
class MolClearPicklist : public MolAction {
public:
  MolClearPicklist(void) { }
  virtual ~MolClearPicklist(void) { }
//  virtual MolAction& act(Molecule *m) { m->clear_picklist(); return *this; }
};

// MolSetPickMode
class MolSetPickMode : public MolAction {
private:
  int val;
public:
  MolSetPickMode(int s) { val = s; }
  virtual ~MolSetPickMode(void) { }
//  virtual MolAction& act(Molecule *m) {m->pick_mode(val); return *this;}
};

// MolSetCenterMode
class MolSetCenterMode : public MolAction {
private:
  int val;
public:
  MolSetCenterMode(int s) { val = s; }
  virtual ~MolSetCenterMode(void) { }
//  virtual MolAction& act(Molecule *m) {m->center_mode(val); return *this;}
};

// MolSetLabelMode
class MolSetLabelMode : public MolAction {
private:
  int val;
public:
  MolSetLabelMode(int s) { val = s; }
  virtual ~MolSetLabelMode(void) { }
//  virtual MolAction& act(Molecule *m) {m->set_label_mode(val); return *this;}
};



#endif
