/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MainFormsObj.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1994/11/27 07:58:41 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The 'controller' for the rest of the forms.  Derived from FormsObj, which
 * is derived from UIObject.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: MainFormsObj.C,v $
 * Revision 1.2  1994/11/27  07:58:41  billh
 * When quit button pressed, now displays confirmation window first.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/MainFormsObj.C,v 1.2 1994/11/27 07:58:41 billh Exp $";
#endif

#include "MainFormsObj.h"
#include "CmdUtil.h"

// commands we are interested in
static int numCmds = 1;
static int cmdList[1] = { Command::QUIT };


// class constructor
MainFormsObj::MainFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("main", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = mainMenu;
  lightButton = main_menu_button;
  offButton = main_menu_off;
  
  // register which commands we are interested in
  for(int i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  // turn on if required
  if(sh)
    On();
}


// routine to check the main form for use
int MainFormsObj::check(FL_OBJECT *obj) {

  if(obj == main_quit_button) {
    if(fl_show_question("Really Quit?", "", ""))
      addcommand(new CmdQuit(TRUE, id()));

  } else
    return FALSE;

  return TRUE;
}

