/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: LightList.h,v $
 *	$Author: billh $	$Locker: billh $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 94/08/24 03:10:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A list of Light objects; used to select a single active one and allow
 * the user to manipulate it.  Also provides an initial set of default lights.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log:	LightList.h,v $
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef LIGHTLIST_H
#define LIGHTLIST_H

#include "Light.h"
#include "DLinkList.h"
#include "Matrix4.h"
extern class Scene;
extern class ColorList;

class LightList : public DLinkList<Light *> {

public:
  LightList(Scene *, ColorList * = NULL);
  virtual ~LightList(void);
  
  // operations to rotate the current light
  void add_rot(float x, char axis);
  void add_rot(Matrix4 &);
  void set_rot(Matrix4 &);

};

#endif
