/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Grid.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:24:14 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Simple template to hold a grid of data
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Grid.h,v $
 * Revision 1.1  1995/02/12  07:24:14  dalke
 * Initial revision
 *
 ***************************************************************************/

// This is an nx, ny, nz grid of <T> values.  That is all.
// It cannot be extended or shrunk, though you could undoubtable
// make a ResizeGrid if needed


#ifndef GRID_TEMPLATE_H
#define GRID_TEMPLATE_H
template<class T>
class Grid {
 private:
   int nx, ny, nz;
   T*** data;
 public:
   Grid(int numx, int numy, int numz);
   ~Grid(void);

   T** operator[](int x) { return data[x];}
   T& item(int x, int y, int z) {
      return data[x][y][z];
   }
   void numrange(int *x, int *y, int *z){
      *x = nx; *y = ny; *z = nz;
   }
};
#endif
