/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Grid.c,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/02/12 07:27:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Template to read an nx, ny, nz grid of <T> data
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Grid.c,v $
 * Revision 1.1  1995/02/12  07:27:08  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/Grid.c,v 1.1 1995/02/12 07:27:08 dalke Exp $";
#endif

#include <malloc.h>
#include "Grid.h"

template<class T>
Grid<T>::Grid(int numx, int numy, int numz)
{
   nx = numx;
   ny = numy;
   nz = numz;

   data = (T*** )malloc(numx * sizeof(T**));
   for (int i=0; i<numx; i++) {
      data[i] = (T**) malloc(numy*sizeof(T*));
      for (int j=0; j<numy; j++) {        // I wonder if I should new this
	 data[i][j] = (T*) malloc(numz*sizeof(T)); // instead?  It works anyway
      }
   }
}

template <class T>
Grid<T>::~Grid(void)
{
   for (int i=0; i<nx; i++) {
      for (int j=0; j<ny; j++) {
	 free(data[i][j]);
      }
      free(data[i]);
   }
   free(data);
}
