/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GeometryFormsObj.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/03/04 05:33:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu for working with the graphical geometry monitors.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GeometryFormsObj.C,v $
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/GeometryFormsObj.C,v 1.1 1995/03/04 05:33:08 billh Exp $";
#endif

#include "GeometryFormsObj.h"
#include "CmdLabel.h"
#include "Geometry.h"
#include "GeometryList.h"
#include "Global.h"

// commands we are interested in
static int numCmds = 3;
static int cmdList[3] = { Command::LABEL_ADD,
	Command::LABEL_DELETE,		Command::LABEL_SHOW };

/////////////////////////  constructor  
GeometryFormsObj::GeometryFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("geometry", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = geometryMenu;
  lightButton = geom_menu_button;
  offButton = geom_menu_off;
  
  // register which commands we are interested in
  for(int i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  // turn on if required
  if(sh)
    On();
}

/////////////////////////  private routines  

// fill the geometry name browser with the current geometry marker names
void GeometryFormsObj::fill_geometry_browser(void) {
  char geomstr[128];
  int cat = fl_get_choice(geom_category) - 1;
  if(cat < 0 || !geometryList)
    return;

  freeze();
    GeomListPtr glist = geometryList->geom_list(cat);
    register int gnum = glist->num();
    register int bnum = fl_get_browser_maxline(geom_browser);
    if(gnum != bnum)
      fl_clear_browser(geom_browser);

    for(int i=0; i < gnum; i++) {
    
      // construct string
      Geometry *g = (*glist)[i];
      strcpy(geomstr, g->name());
      strcat(geomstr, (g->on() ? " (on)" : " (off)"));
      
      // put in browser
      if(gnum != bnum)
        fl_add_browser_line(geom_browser, geomstr);
      else
        fl_replace_browser_line(geom_browser, i+1, geomstr);
    }
  unfreeze();
}


//////////////////////  protected virtual routines  

// routine to check the main form for use
int GeometryFormsObj::check(FL_OBJECT *obj) {

  if(obj == geom_browser || obj == geom_graph_cmd) {
    ; 		// do nothing

  } else if(obj == geom_graph) {
    // graph the selected items
    for(int i=1; i <= fl_get_browser_maxline(geom_browser); i++) {
      if(fl_isselected_browser_line(geom_browser, i))
        addcommand(new CmdLabelGraph(fl_get_choice_text(geom_category),
      			i-1, fl_get_input(geom_graph_cmd), id()));
    }

  } else if(obj == geom_select_all) {
    // make all items in the current category be selected
    freeze();
      for(int i=fl_get_browser_maxline(geom_browser); i >= 1; i--)
        fl_select_browser_line(geom_browser, i);
    unfreeze();

  } else if(obj == geom_select_none) {
    // make no items in the current category be selected
    fl_deselect_browser(geom_browser);

  } else if(obj == geom_category) {
    // new category selected; display it now
    fill_geometry_browser();
    
  } else if(obj == geom_show || obj == geom_hide) {
    // for all selected geometries, set show/hide flag
    int selected = 0;
    for(int i=fl_get_browser_maxline(geom_browser); i >= 1; i--) {
      if(fl_isselected_browser_line(geom_browser, i)) {
        selected = 1;
	addcommand(new CmdLabelShow(fl_get_choice_text(geom_category),
			(obj == geom_show), i-1, id()));
      }
    }
    if(!selected && fl_get_browser_maxline(geom_browser) > 0)
      addcommand(new CmdLabelShow(fl_get_choice_text(geom_category),
			(obj == geom_show), (-1), id()));
  
  } else if(obj == geom_delete) {
    // delete all selected geometries
    int selected = 0;
    for(int i=fl_get_browser_maxline(geom_browser); i >= 1; i--) {
      if(fl_isselected_browser_line(geom_browser, i)) {
        selected = 1;
	addcommand(new CmdLabelDelete(fl_get_choice_text(geom_category),
			i-1, id()));
      }
    }
    if(!selected && fl_get_browser_maxline(geom_browser) > 0)
      addcommand(new CmdLabelDelete(fl_get_choice_text(geom_category),
			(-1), id()));
    
  } else
    return FALSE;

  return TRUE;
}


// do form-specific acting on commands.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
// here, don't need this, just take parent class version
int GeometryFormsObj::forms_act_on_command(int type, Command *, int) {

  MSGDEBUG(3,"GeometryFormsObj: acting on command " << type << sendmsg);

  // check all the possible commands that we look for ...
  if(type == Command::LABEL_ADD || type == Command::LABEL_DELETE
	|| type == Command::LABEL_SHOW) {
    fill_geometry_browser();

  } else
    // unknown command type
    return FALSE;
    
  return TRUE;
}


//////////////////////  public virtual routines  

// initialize the user interface
void GeometryFormsObj::init(void) {
 
  freeze();
    // fill category choice
    fl_clear_choice(geom_category);
    if(geometryList) {
      for(int i=0; i < geometryList->num_lists(); i++)
        fl_addto_choice(geom_category, geometryList->geom_list_name(i));
    }

    // put in initial suggestion for graphing command
    fl_set_input(geom_graph_cmd, "xgraph %s");

    // do a reset to set initial values
    reset();

  unfreeze();
}


// reset the user interface
void GeometryFormsObj::reset(void) {
  freeze();
    fill_geometry_browser();
  unfreeze();
}

