/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryDihedral.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1995/03/04 05:33:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between four atoms, and draws a marker for the dihedral
 * into the display list for a given Displayable.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GeometryDihedral.h,v $
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef GEOMETRYDIHE_H
#define GEOMETRYDIHE_H

#include "GeometryMol.h"


class GeometryDihedral : public GeometryMol {

public:
  // constructor: molecule id's, atom indices, molecule list
  GeometryDihedral(int *, int *, MoleculeList *);
  
  //
  // public virtual routines
  //
  
  // recalculate the value of this geometry, and return it
  virtual float calculate(void);
  
  // draw the geometry marker in the given Displayable's drawing list
  virtual void draw_marker(Displayable *);

};

#endif
