/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryAngle.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1995/03/04 05:33:08 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between three atoms, and draws a marker for the angle
 * into the display list for a given Displayable.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GeometryAngle.C,v $
 * Revision 1.1  1995/03/04  05:33:08  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/GeometryAngle.C,v 1.1 1995/03/04 05:33:08 billh Exp $";
#endif

#include "GeometryAngle.h"
#include "MoleculeList.h"
#include "Molecule.h"
#include "utilities.h"


////////////////////////  constructor  /////////////////////////
GeometryAngle::GeometryAngle(int *m, int *a, MoleculeList *mlist)
	: GeometryMol(3, m, a, mlist) {

}


////////////////////  public virtual routines  //////////////////////

// recalculate the value of this geometry, and return it
float GeometryAngle::calculate(void) {

  // get coords to calculate distance 
  float pos1[3], pos2[3], pos3[3], r1[3], r2[3];
  if(!normal_atom_coord(objIndex[0], comIndex[0], pos1))
    return 0.0;
  if(!normal_atom_coord(objIndex[1], comIndex[1], pos2))
    return 0.0;
  if(!normal_atom_coord(objIndex[2], comIndex[2], pos3))
    return 0.0;

  subtract(r1, pos1, pos2);
  subtract(r2, pos2, pos3);
  return(geomValue = angle(r1, r2));
}


// draw the geometry marker in the given Displayable's drawing list
void GeometryAngle::draw_marker(Displayable *d) {
  char valbuf[32];

  // get the transformed positions, and draw a line between them
  float pos1[3], pos2[3], pos3[3];
  if(!transformed_atom_coord(objIndex[0], comIndex[0], pos1))
    return;
  if(!transformed_atom_coord(objIndex[1], comIndex[1], pos2))
    return;
  if(!transformed_atom_coord(objIndex[2], comIndex[2], pos3))
    return;

  // draw a line into the given Displayable
  display_line(pos1, pos2, d);
  display_line(pos2, pos3, d);
  
  // print value of distance at midpoint
  midpoint(valuePos, pos1, pos3);
  midpoint(valuePos, valuePos, pos2);
  sprintf(valbuf, "%7.2f", geomValue);
  display_string(valbuf, d);
}
