/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GLRenderer.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/02/22 04:07:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of DisplayDevice, this object has routines used by all the
 * different display devices that are GL-specific.  Will render drawing
 * commands into a single GL window.  This is not the complete definition,
 * however, of a DisplayDevice; something must provide routines to open
 * windows, reshape, clear, set perspective, etc.  This object contains the
 * code to render a display command list.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: GLRenderer.h,v $
 * Revision 1.3  1995/02/22  04:07:05  billh
 * Added virtual routine find_3D_from_2D, which takes a 3D point at pos A,
 * and 2D rel screen position at B, and returns the 3D point corresponding
 * to the 2D point at B in the same plane as point A.
 *
 * Revision 1.2  94/10/04  22:07:55  billh
 * Took out sphere library usage if __NPGL__ is defined, since the npgl library
 * does not have a version of the sphere drawing routines.  Spheres are
 * just drawn as points for npgl rendering.
 * 
 * Revision 1.1  94/09/23  06:01:39  billh
 * Initial revision
 * 
 ***************************************************************************/
#ifndef GLRENDERER_H
#define GLRENDERER_H

#include <gl.h>
#include <gl/device.h>
#include <math.h>
#include "DisplayDevice.h"

#ifndef __NPGL__
#include <gl/sphere.h>
#endif

class GLRenderer : public DisplayDevice {

private:
  // pointer to data block (should be changed to allow for multiple blocks)
  float *dataBlock;
  
  // do we need to turn antialiasing and depth-cueing on when materials
  // are turned off?
  int need_aaon, need_cueon;

protected:
  // routines to perform various GL-specific graphics operations
  void set_line_width(int);
  void set_line_style(int);
  void set_sphere_res(int);
  void set_sphere_mode(int);
  void triangle(float *norm, float *, float *, float *);// triangle with normal
  void square(float *norm, float *, float *, float *, float *); 
  void cylinder(float *, float *, int, float);
  void cone(float *, float *, int, float);
  
  //
  // protected virtual routines
  //
  
  // virtual routines to deal with light sources at device level
  // all return success of operation
  virtual int do_define_light(int n, float *color, float *position);
  virtual int do_activate_light(int n, int turnon);

  // virtual routines to deal with materials at device level
  // all return success of operation
  virtual int do_define_material(int n, float *data);
  virtual int do_activate_material(int n, int turnon);

public:
  // constructor/destructor
  GLRenderer(char *);
  virtual ~GLRenderer(void);

  //
  // virtual routines to affect the device's transformation matrix
  //
  
  virtual void push(void);		// push device's curr state on stack
  virtual void pop(void);		// pop device's curr state from stack
  virtual void loadmatrix(Matrix4 &);	// replace trans matrix with given one
  virtual void multmatrix(Matrix4 &);	// multiply trans matrix with given one

  //
  // virtual routines to find characteristics of display itself
  //

  // return absolute 2D screen coordinates, given 2D or 3D world coordinates.
  virtual void abs_screen_loc_3D(float *, long *);
  virtual void abs_screen_loc_2D(float *, long *);

  // size of physical display object
  virtual void screen_size_mm(long& x, long& y) {
    x = getgdesc(GD_XMMAX);  y = getgdesc(GD_YMMAX);
  }
  
  virtual void screen_size_pixel(long& x, long& y) {
    x = getgdesc(GD_XPMAX);  y = getgdesc(GD_YPMAX);
  }

  // Given a 3D point (pos A),
  // and a 2D rel screen pos point (for pos B), computes the 3D point
  // which goes with the second 2D point at pos B.  Result returned in B3D.
  virtual void find_3D_from_2D(float *A3D, float *B2D, float *B3D);

  //
  // virtual functions to turn on/off depth cuing and antialiasing
  //
  
  virtual void aa_on(void);
  virtual void aa_off(void);
  virtual void cueing_on(void);
  virtual void cueing_off(void);

  //
  // virtual routines for preparing to draw, drawing, and finishing drawing
  //
  
  virtual void render(void *cmdlist);		// process list of draw cmds

};

#endif
