/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FormsObj.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1995/02/22 04:06:23 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The FORMS object, which is one single form that can be turned on/off,
 * initialized, etc  It is a base class for specific
 * forms.  It assumes that this is for use with a MoleculeList, and will
 * use the specified DisplayDevice.
 * This class is derived from UIObject; it can generate and receive commands.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: FormsObj.C,v $
 * Revision 1.7  1995/02/22  04:06:23  billh
 * Now queues keyboard in order to get keyboard events.
 *
 * Revision 1.6  94/11/11  16:31:17  billh
 * All forms now get REMOTE_RUN and REMOTE_ATTACH commands which set the
 * top molecule and do a reset.
 * 
 * Revision 1.5  94/10/28  18:36:05  billh
 * Updated due to conversion of Mouse to a general base class.  Window
 * events have also been made non-GL-specific.
 * 
 * Revision 1.4  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.3  1994/09/29  07:10:48  billh
 * Made act_on_command call protected virtual forms_act_on_command so that
 * forms versions of these objects get updated after a command properly.
 *
 * Revision 1.2  94/09/17  09:02:01  billh
 * Returned code to deal with working with moleculeList and Molecules.
 * 
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/FormsObj.C,v 1.7 1995/02/22 04:06:23 billh Exp $";
#endif

#include <stdio.h>
#include <strings.h>
#include <gl/gl.h>
#include <gl/device.h>
#include "FormsObj.h"
#include "Inform.h"
#include "CmdMenu.h"
#include "Mouse.h"
#include "MoleculeList.h"


// static member initialization
int FormsObj::formsInitialized = FALSE;
int FormsObj::checkNewEvents = TRUE;


// commands we are interested in
static int numCmds = 6;
static int cmdList[6] = { Command::GUI_EVENT, Command::MOL_NEW,
	Command::MOL_TOP, 		Command::MOL_DEL,
	Command::REMOTE_ATTACH,		Command::REMOTE_RUN
};


// class constructor
FormsObj::FormsObj(char *form_name, UIList *uil, CommandQueue *cq, 
	int show_border, int *new_pos)
  : UIObject(form_name, uil, cq) {
  int i;

  // call create_the_forms, if necessary
  if(!formsInitialized) {
    MSGDEBUG(1,"FormsObj: initializing the forms windows ... " << sendmsg);

    create_the_forms();

    // express interest in certain GL events
    fl_qdevice(REDRAW);
    fl_qdevice(INPUTCHANGE);
    fl_qdevice(KEYBD);
    fl_qdevice(RIGHTMOUSE);
    fl_qdevice(MIDDLEMOUSE);
    fl_qdevice(LEFTMOUSE);
//    fl_qdevice(MOUSEX);
//    fl_qdevice(MOUSEY);

    formsInitialized = TRUE;
  }
  
  MSGDEBUG(1,"Creating form '" << name << "' ..." << sendmsg);

  // register which commands we are interested in
  for(i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  form = NULL;
  formShowing = FALSE;
  border = show_border;
  mol = moleculeList->top();
  lightButton = offButton = NULL;
  
  if(new_pos) {
    placeMethod = FL_PLACE_POSITION;
    formPosition[0] = new_pos[0];
    formPosition[1] = new_pos[1];
  } else
    placeMethod = FL_PLACE_SIZE;
}


// class destructor
FormsObj::~FormsObj(void) {
  Off();
}


// move the form
void FormsObj::move(int x, int y) {
  placeMethod = FL_PLACE_POSITION;
  formPosition[0] = x;
  formPosition[1] = y;
  fl_set_form_position(form, x, y);
}


// turn the form on
void FormsObj::On(void) {

  if(!formShowing) {
    if(placeMethod == FL_PLACE_POSITION)
      fl_set_form_position(form,formPosition[0],formPosition[1]);
    fl_show_form(form,placeMethod,border,name);
    formShowing = TRUE;
    if(lightButton && fl_get_button(lightButton) != formShowing)
      fl_set_button(lightButton, formShowing);
  }
}


// turn the form off
void FormsObj::Off(void) {

  if(formShowing) {
    placeMethod = FL_PLACE_POSITION;
    formPosition[0] = (int)(form->x);
    formPosition[1] = (int)(form->y);
    fl_hide_form(form);
    formShowing = FALSE;
    if(lightButton && fl_get_button(lightButton) != formShowing)
      fl_set_button(lightButton, formShowing);
  }
}


// routine to set an input object to an integer value
void FormsObj::set_input_int(FL_OBJECT *obj, int val, int places) {
  char buf[80];

  sprintf(buf,"%-*d",places,val);
  fl_set_input(obj,buf);
}


// update the display
void FormsObj::update(void) {
  checkNewEvents = TRUE;
}


// check for an event, and queue it if found.  Return TRUE if an event
// was generated.
int FormsObj::check_event(void) {
  FL_OBJECT *obj;
  long dev;
  short val;

  // only do this if no other FormsObj's have ...
  if(!checkNewEvents)
    return FALSE;
    
  MSGDEBUG(3,"FormsObj: checking for events ... " << sendmsg);

  checkNewEvents = FALSE;
    
  // get a forms event if one exists
  if(!(obj = fl_check_forms()))
    return FALSE;
      
  // event found; determine if GL or FORMS
  if(obj == FL_EVENT) {			// GL event
    if(!fl_qtest())			// but it's bogus ...
      return FALSE;
    dev = fl_qread(&val);
    int eventCode;
    int newval = val;
//    if(dev == MOUSEX)
//      eventCode = WinEvent::WIN_MOUSEX;
//    else if(dev == MOUSEY)
//      eventCode = WinEvent::WIN_MOUSEY;
//    else 
    if(dev == LEFTMOUSE)
      eventCode = WinEvent::WIN_LEFT;
    else if(dev == MIDDLEMOUSE)
      eventCode = WinEvent::WIN_MIDDLE;
    else if(dev == RIGHTMOUSE)
      eventCode = WinEvent::WIN_RIGHT;
    else if(dev == KEYBD)
      eventCode = WinEvent::WIN_KEYBD;
    else if(dev == REDRAW)
      eventCode = WinEvent::WIN_REDRAW;
    else
      eventCode = WinEvent::WIN_INPUTCHANGE;

    addcommand(new WinEvent(eventCode, newval, id()));
  } else {
    addcommand(new GUIEvent(obj,id()));
  }

  return TRUE;
}


// update the display due to a command being executed.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
int FormsObj::act_on_command(int type, Command *cmd, int suc) {
  int frm_retval;

  MSGDEBUG(2,"FormsObj: acting on command " << type << sendmsg);

  // have derived class check command
  frm_retval = forms_act_on_command(type, cmd, suc);

  // do extra checking
  if(type == Command::GUI_EVENT) {
    FL_OBJECT *obj = ((GUIEvent *)cmd)->obj;

    // check if this form has the associated object
    if(obj == lightButton) {
      MSGDEBUG(2,"On/Off toggle button pressed for menu '" << name << "'.");
      MSGDEBUG(2,sendmsg);
      addcommand(new CmdMenuShow(id(),fl_get_button(obj),id()));
    } else if(obj == offButton) {
      MSGDEBUG(2,"Off button pressed for menu '" << name << "'.");
      MSGDEBUG(2,sendmsg);
      addcommand(new CmdMenuShow(id(),FALSE,id()));
    } else {
      MSGDEBUG(2,"  forms-specific event; checking '" << name << "' ...");
      MSGDEBUG(2,sendmsg);
      return frm_retval || check(obj);
    }

  } else if(type == Command::MOL_TOP	|| type == Command::MOL_DEL ||
	    type == Command::MOL_NEW	|| type == Command::REMOTE_ATTACH ||
	    type == Command::REMOTE_RUN) {
    mol = moleculeList->top();
    reset();
    
  } else
    return frm_retval;

  MSGDEBUG(2,"'" << name << "' ... done acting on command " << type);
  MSGDEBUG(2,sendmsg);

  return TRUE;
}
