/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: Enterprise.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1994/09/02 22:21:52 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  A figure which looks somewhat like the NCC 1701 Enterprise
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Enterprise.h,v $
 * Revision 1.1  1994/09/02  22:21:52  dalke
 * Initial revision
 *
 ***************************************************************************/

/* most of this comes from Axes.[Ch] */

#ifndef ENTERPRISE_H
#define ENTERPRISE_H

#include "Displayable.h"
#include "DispCmds.h"

class Enterprise : public Displayable3D {

private:
  // lines defining the Enterprise
//   _________________     ________________
//  |_________________|   |________________|
//      ________| |______/_/       
//     |                  |.   (the . is the origin)
//     |__________________|
//
  float hullStart[3], hullEnd[3]; float hullRadius;

  float nacelleRadius;
// float nacelleSupportRadius;  // supports not (yet) done
  float nacelle1Start[3], nacelle1End[3];
  float nacelle2Start[3], nacelle2End[3];

//  float saucerSupportRadius;
//  float saucerSupportStart[3], saucerSupportEnd[3];

  float saucerRadius;
   float saucerStart[3], saucerEnd[3];

  void create_cmdlist( void);
  
public:
  // constructor; the Scene to register this with
  Enterprise(Scene *);
  virtual ~Enterprise(void) { };
  
  // prepare to drawing
  virtual void prepare(DisplayDevice *);

};


#endif /* ENTERPRISE_H */
