/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawMolecule.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/12 07:20:34 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Displayable version of a DrawMolecule, derived from BaseMolecule and
 * Displayable3D.  This contains all the info for rendering
 * the molecule.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: DrawMolecule.C,v $
 * Revision 1.2  1995/02/12  07:20:34  dalke
 * migrated stuff to virtual, and made DrawMolecule be 3D
 *
 * Revision 1.1  1994/10/26  23:24:01  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/DrawMolecule.C,v 1.2 1995/02/12 07:20:34 dalke Exp $";
#endif

#include "DrawMolecule.h"
#include "AtomColor.h"
#include "AtomRep.h"
#include "AtomSel.h"
#include "utilities.h"

// storage for frame text string
static char *frameTextBuf = "Time: +000.00000";

// data for drawing frame position indicator
#define FRPF	0.02
#define FRPL	0.1
static float framePosPoints[6][3] = { { FRPF, FRPF + FRPL, 0.0 },
	{ FRPF, FRPF, 0.0 }, {1.0 - FRPF, FRPF, 0.0},
	{1.0 - FRPF, FRPF + FRPL, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0} };



///////////////////////  constructor and destructor
DrawMolecule::DrawMolecule(Scene *sc)
	: Displayable3D(MULT, "", sc, 4), repList(8),
	  dataCmd(6, framePosPoints[0]), cmdTxt(frameTextBuf) {
  needRedraw = TRUE;
  active = TRUE;
}

DrawMolecule::DrawMolecule(Displayable *par)
	: Displayable3D(MULT,"",par,4), repList(8),
	  dataCmd(6, framePosPoints[0]), cmdTxt(frameTextBuf) {
  needRedraw = TRUE;
  active = TRUE;
}
  
// destructor ... free up any extra allocated space (the child Displayables
// will be deleted by the Displayable3D destructor)
DrawMolecule::~DrawMolecule(void) {
  // delete all molecule representations
  for(int i=0; i < components(); i++)
    delete component(i);  
}


///////////////////////  private routines

// regenerate the command list
void DrawMolecule::create_cmdlist(void) {

  MSGDEBUG(2,"DrawMolecule: creating command list ..." << sendmsg);

  reset_disp_list();

/*
  cmdMaterials.putdata(FALSE,this);
  cmdLineWidth.putdata(1,this);
  cmdCol.putdata(REGWHITE, this);
  dataCmd.put(this);
  cmdLine.putdata(0, 1, this);
  cmdLine.putdata(1, 2, this);
  cmdLine.putdata(2, 3, this);
  cmdLine.putdata(4, 5, this);
*/

}
  

///////////////////////  public routines

// routine to set the name of the molecule
void DrawMolecule::set_name(char *newname) {
  if(name)  delete [] name;
  name = new char[strlen(newname) + 8];
  sprintf(name,"%s:%03d",newname,id());
}


// create the molecule.  Successive classes should call their parent 'create'
// after they are done.
// Returns success .... if not successful, should be 'delete'ed
int DrawMolecule::create(void) {
  int retval;

  // do base class creation first
  if((retval = BaseMolecule::create()) == TRUE) {
    // update coordinates in display list
    create_cmdlist();
  }
  
  return retval;
}


// prepare for drawing ... do any updates needed right before draw.
//  ... this updates the animation
void DrawMolecule::prepare(DisplayDevice *) {

  // update the animation
  anim_update();
  
  // if frame changed, must recreate display list
//  if(has_frame_changed())
//    create_cmdlist();
}


// return Nth component ... change to proper return type
DrawMolItem *DrawMolecule::component(int n) {
  if(n >= 0 && n < components())
    return repList[n];
  else
    return NULL;
}


// delete the Nth representation ... return success
int DrawMolecule::del_rep(int n) {
  DrawMolItem *rep = component(n);
  if(rep) {
    delete rep;		// delete the object
    repList.remove(n);	// and it's slot in the representation list
  }

  return (rep != NULL);
}


// add a new representation (component) ... return success
int DrawMolecule::add_rep(AtomColor *ac, AtomRep *ar, AtomSel *as) {
    AtomColor *newac;
    AtomRep *newar;
    AtomSel *newas;

    // create new representation objects
    if(!ac)
      newac = new AtomColor(NULL, NULL);
    else
      newac = new AtomColor(*ac);
    
    if(!ar)
      newar = new AtomRep();
    else
      newar = new AtomRep(*ar);
      
    if(!as)
      newas = new AtomSel(NULL);
    else
      newas = new AtomSel(*as);

    // find the selected atoms to display, and the color for each atom
    newas->find(this);
    newac->find(this);

    // make sure the selections are now all ok
    if (newas->selected == 0) {
      msgErr << "No atoms selected";
    } else {
      // create new rep; it will add itself as a child to this object
      repList.append(new DrawMolItem(this, newac, newar, newas));
      return TRUE;
    }
    
    // if we're here, there was an error
    msgErr << " ... new rep not added." << sendmsg;
    delete newas;
    delete newar;
    delete newac;
    return FALSE;
}


// change the Nth representation ... return success.
// if any object is NULL, that characteristic is not changed.
int DrawMolecule::change_rep(int n, AtomColor *ac, AtomRep *ar, AtomSel *as) {
  DrawMolItem *rep = component(n);
  if(rep) {
    rep->change_color(ac);
    rep->change_rep(ar);
    rep->change_sel(as);
    return TRUE;
  } else
    return FALSE;
}



