/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdTrans.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.6 $      $Date: 1994/10/04 20:29:22 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for transforming the current scene.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdTrans.h,v $
 * Revision 1.6  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.5  1994/10/03  01:39:42  dalke
 * Took code from .h to .C, leaving only prototypes (to reduce inlining)
 *
 * Revision 1.4  1994/09/30  19:06:51  dalke
 * Took mouse reference out if VMDFORMS not definds
 *
 * Revision 1.3  1994/09/12  20:53:55  billh
 * Added CmdResetView command (RESETVIEW).
 *
 * Revision 1.2  94/08/26  00:00:39  billh
 * Added STOPROT command.
 * 
 * Revision 1.1  94/08/24  03:10:37  billh
 * Initial revision
 * 
 ***************************************************************************/

#ifndef CMDTRANS_H
#define CMDTRANS_H

#include "Command.h"

// The following uses the Cmdtypes ROTATE, TRANSLATE, SCALE, ROCKON, ROCKOFF,
// STOPROT, RESETVIEW from the Command class

///////////////// rotate the current scene
class CmdRotate : public Command {
public:
  // enum with how to rotate, 'by' or 'to'
  enum { BY, TO };

public:
  // axis to rotate
  char axis;
  
  // amount to rotate
  float deg;
  
  // set, or add to, rotation?
  int byOrTo;
  
protected:
  virtual int do_execute(void) ;

public:
  CmdRotate(float a, char ax, int by_or_to, int newUIid=(-1));
};


///////////////// translate the current scene
class CmdTranslate : public Command {
public:
  // enum with how to translate, 'by' or 'to'
  enum { BY, TO };

public:
  // amount to translate
  float x, y, z;
  
  // set, or add to, translation?
  int byOrTo;
  
protected:
  virtual int do_execute(void) ;
public:
  CmdTranslate(float nx, float ny, float nz, int by_or_to, int newUIid=(-1));
};


///////////////// scale the current scene
class CmdScale : public Command {
public:
  // enum with how to scale, 'by' or 'to'
  enum { BY, TO };

public:
  // amount to scale
  float s;
  
  // set, or multiply, scaling?
  int byOrTo;
  
protected:
  virtual int do_execute(void) ;

public:
  CmdScale(float ns, int by_or_to, int newUIid=(-1));
};


///////////////// rock the current scene
class CmdRockOn : public Command {
public:
  // axis to rock
  char axis;
  
  // amount to rock
  float deg;

  // steps to rock (if < 0, continuous)
  int steps;

protected:
  virtual int do_execute(void) ;

public:
  CmdRockOn(float a, char ax, int nsteps, int newUIid=(-1));
};


///////////////// stop rocking the current scene
class CmdRockOff : public Command {
protected:
  virtual int do_execute(void) ;

public:
  CmdRockOff(int newUIid=(-1)) ;
};


///////////////// stop rotating (both rocking, and mouse movement) for
///////////////// the current scene
class CmdStopRot : public Command {
protected:
  virtual int do_execute(void) ;

public:
  CmdStopRot(int newUIid=(-1)) ;
};


///////////////// reset the current view for the current scene
class CmdResetView : public Command {
protected:
  virtual int do_execute(void) ;

public:
  CmdResetView(int newUIid=(-1)) ;
};


#endif
