/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTrans.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1994/10/28 18:36:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Command objects for transforming the current scene.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdTrans.C,v $
 * Revision 1.3  1994/10/28  18:36:05  billh
 * Updated due to conversion of Mouse to a general base class.  Window
 * events have also been made non-GL-specific.
 *
 * Revision 1.2  1994/10/04  20:29:22  billh
 * Changes to get to compile on HP's ... not there yet,though.
 *
 * Revision 1.1  1994/10/03  01:42:46  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/CmdTrans.C,v 1.3 1994/10/28 18:36:05 billh Exp $";
#endif

#include <ctype.h>
#include "CmdTrans.h"
#include "Global.h"
#include "Scene.h"
#include "Mouse.h"
#include "utilities.h"

// The following uses the Cmdtypes ROTATE, TRANSLATE, SCALE, ROCKON, ROCKOFF,
// STOPROT, RESETVIEW from the Command class

///////////////// rotate the current scene
int CmdRotate::do_execute(void) {
  int retval;
  if(retval = (scene != NULL)) {
    scene->stop_rocking();
    if(byOrTo == CmdRotate::BY) {
      scene->add_rot(deg, axis);
    } else {			// first clear rotation, then set to value
      Matrix4 tempIdent;
      scene->set_rot(tempIdent);
      scene->add_rot(deg, axis);
    }
  }
  return retval;
}

CmdRotate::CmdRotate(float a, char ax, int by_or_to, int newUIid)
  : Command(Command::ROTATE, newUIid) {
  deg = a;
  axis = ((ax >= 'x' && ax <= 'z') ? ax : 'y');
  byOrTo = by_or_to;

  *cmdText << "rot " << axis;
  *cmdText << ( byOrTo == CmdRotate::BY ? " by " : " to ");
  *cmdText << deg;
  *cmdText << ends;
}


///////////////// translate the current scene
int CmdTranslate::do_execute(void) {
  int retval;
  if(retval = (scene != NULL)) {
    if(byOrTo == CmdTranslate::BY) {
      scene->add_glob_trans(x,y,z);
    } else {
      scene->set_glob_trans(x,y,z);
    }
  }
  return retval;
}

CmdTranslate::CmdTranslate(float nx, float ny, float nz, int by_or_to, 
                              int newUIid)
  : Command(Command::TRANSLATE, newUIid) {
  x = nx;  y = ny;  z = nz;
  byOrTo = by_or_to;

  *cmdText << "trans x ";
  *cmdText << ( byOrTo == CmdTranslate::BY ? "by " : "to ");
  *cmdText << x << " y ";
  *cmdText << ( byOrTo == CmdTranslate::BY ? "by " : "to ");
  *cmdText << y << " z ";
  *cmdText << ( byOrTo == CmdTranslate::BY ? "by " : "to ");
  *cmdText << z;
  *cmdText << ends;
}


///////////////// scale the current scene
int CmdScale::do_execute(void) {
  int retval;
  if(retval = (scene != NULL)) {
    if(byOrTo == CmdScale::BY) {
      scene->mult_scale(s);
    } else {
      scene->set_scale(s);
    }
  }
  return retval;
}

CmdScale::CmdScale(float ns, int by_or_to, int newUIid)
  : Command(Command::SCALE, newUIid) {
  s = ns;
  byOrTo = by_or_to;

  *cmdText << "scale ";
  *cmdText << ( byOrTo == CmdScale::BY ? "by " : "to ");
  *cmdText << ns;
  *cmdText << ends;
}


///////////////// rock the current scene
int CmdRockOn::do_execute(void) {
  int retval;
  if(retval = (scene != NULL))
    scene->start_rocking(deg, axis, steps);
  return retval;
}

CmdRockOn::CmdRockOn(float a, char ax, int nsteps, int newUIid)
  : Command(Command::ROCKON, newUIid) {
  deg = a;
  axis = ((ax >= 'x' && ax <= 'z') ? ax : 'y');
  steps = nsteps;

  *cmdText << "rock " << axis << " by " << deg;
  if(steps >= 0)
    *cmdText << " " << steps;
  *cmdText << ends;
}


///////////////// stop rocking the current scene
int CmdRockOff::do_execute(void) {
  int retval;
  if(retval = (scene != NULL))
    scene->stop_rocking();
  return retval;
}

CmdRockOff::CmdRockOff(int newUIid) : Command(Command::ROCKOFF, newUIid) {
  *cmdText << "rock off";
  *cmdText << ends;
}


///////////////// stop rotating (both rocking, and mouse movement) for
///////////////// the current scene
int CmdStopRot::do_execute(void) {
  int retval;
  if(retval = (scene != NULL)) {
    scene->stop_rocking();
    if(retval = (mouse != NULL))
      mouse->stop_rotation();
  }
  return retval;
}

CmdStopRot::CmdStopRot(int newUIid) : Command(Command::STOPROT, newUIid) {
  *cmdText << "rot stop";
  *cmdText << ends;
}


///////////////// reset the current view for the current scene
int CmdResetView::do_execute(void) {
  int retval;
  if(retval = (scene != NULL))
    scene->reset_transformation();
  return retval;
}

CmdResetView::CmdResetView(int newUIid) : Command(Command::RESETVIEW, newUIid) {
  *cmdText << "view reset";
  *cmdText << ends;
}

