/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTracker.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1994/10/04 19:47:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  The Cmds to start and pause a tracker are defined here
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdTracker.h,v $
 * Revision 1.4  1994/10/04  19:47:15  billh
 * Took out comment from include steaatement
 *
 * Revision 1.3  1994/09/17  09:40:26  dalke
 * fixed delete bug, moved some global variables to UIVR
 *
 * Revision 1.2  1994/09/15  07:04:54  dalke
 * Added "information" commands for the tracker (like ListAvail, Loc, ...)
 * Added pause/ unpause Command (CmdTrackerPause, CmdTrackerUnpause)
 *
 * Revision 1.1  1994/09/07  07:56:04  dalke
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDTRACKER_H
#define CMDTRACKER_H

#include "Command.h"
#include "TrackerList.h"
#include "Tracker.h"
#include "UIVR.h"

// these are the Commands used:
//      TRACKER_START, TRACKER_PAUSE, TRACKER_LIST, TRACKER_LIST_AVAIL,
//      TRACKER_LOC, TRACKER_UNPAUSE,

// Start a tracker
class CmdTrackerStart : public Command { //##########
public:
  int availnum;
  char *hostname;
protected:
  virtual int do_execute(void) {
     return trackerList ? 
               (trackerList -> start_avail(availnum, hostname)) == TRACKER_OK
             : FALSE;    
  }
public:
  CmdTrackerStart(int newavailnum, char *newhostname=NULL, int fromUIid = -1)
    : Command(Command::TRACKER_START, fromUIid)
 {
    
    hostname = stringdup(newhostname);
    availnum = newavailnum;
    // the +1 is because most people are 1 based
    *cmdText << "tracker start " << newavailnum + 1;
    if (newhostname != NULL)
      *cmdText << " on " << newhostname;
    *cmdText << ends;
  }
  virtual ~CmdTrackerStart( void) {
    delete [] hostname;
  }
};

// Pause a tracker, given its number on the list
class CmdTrackerPause : public Command {  //##########
public:
  int trackernum;
protected:
  virtual int do_execute(void) {
    return trackerList && trackerList->tracker(trackernum) ? 
           trackerList -> tracker(trackernum) -> pause(), TRUE :
           FALSE;
  }
public:
  CmdTrackerPause(int tmptrackernum, int fromUIid = -1)
    : Command(Command::TRACKER_PAUSE, fromUIid) {
    
    trackernum = tmptrackernum;
    // the +1 is because most people are 1 based
    *cmdText << "tracker pause " << tmptrackernum+1 << ends;
  }
  virtual ~CmdTrackerPause( void) {
  }
};

// unpause a tracker, given its number
class CmdTrackerUnpause : public Command { //##########
public:
  int trackernum;
protected:
  virtual int do_execute(void) {
    return trackerList && trackerList->tracker(trackernum) ? 
           trackerList -> tracker(trackernum) -> unpause(), TRUE :
           FALSE;
  }
public:
  CmdTrackerUnpause(int tmptrackernum, int fromUIid = -1)
    : Command(Command::TRACKER_UNPAUSE, fromUIid) {
    
    trackernum = tmptrackernum;
    // the +1 is because most people are 1 based
    *cmdText << "tracker unpause " << tmptrackernum+1 << ends;
  }
  virtual ~CmdTrackerUnpause( void) {
  }
};

// list all the available trackers
class CmdTrackerListAvail : public Command {
protected:
  virtual int do_execute(void);  // leave it up to the .C file
public:
  CmdTrackerListAvail(int fromUIid = -1)
    : Command(Command::TRACKER_LIST_AVAIL, fromUIid) {
    *cmdText << "tracker list avail" << ends;
  }
  virtual ~CmdTrackerListAvail(void) { }
};
// list all running trackers
class CmdTrackerList : public Command {
protected:
  virtual int do_execute(void);  // leave it up to the .C file
public:
  CmdTrackerList(int fromUIid = -1)
    : Command(Command::TRACKER_LIST, fromUIid) {
    *cmdText << "tracker list" << ends;
  }
  virtual ~CmdTrackerList(void) { }
};
    
// print the current location of a tracker/ sensor pair
class CmdTrackerLoc : public Command {
public:
  int trackernum;
  int sensornum;
protected:
  virtual int do_execute( void);  // leave it up to the .C file
public:
  CmdTrackerLoc(int tracker, int sensor, int fromUIid = -1)
    : Command(Command::TRACKER_LOC, fromUIid) {
    *cmdText << "tracker location " << tracker+1 // again, people are 1 based
       << " " << sensor+1 << ends;
    trackernum = tracker;
    sensornum = sensor;
  }
  ~CmdTrackerLoc( void) {}
};

#endif
