/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdPick.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1995/02/22 03:56:04 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 	The picking commands are defined here.  A picking command must
 * know which button was used, what the x,y position was, and what was
 * the picking mode.
 *
 *	The x,y position (for 2D picking) is relative to the windows lower-
 * left corner, and scaled to be in the range 0 ... 1.  A general utility
 * routine "rel_screen_pos" in the DisplayDevice class converts absolute
 * screen coordinates for the given display into these relative coords.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdPick.h,v $
 * Revision 1.1  1995/02/22  03:56:04  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef CMDPICK_H
#define CMDPICK_H

#include "Command.h"

// The following uses the Cmdtypes PICK_START, PICK_MOVE, and PICK_END
// from the Command class

//////////// general base class for picking commands
class CmdPickBase : public Command {
protected:
  int pickMode;		// mode in when picking started
  int button;		// which button used for pick (0 == LEFT, 1 == MIDDLE)
  int dim;		// dimension of picking (2 or 3)
  float p[3];	// position of pointer at start.  Usage depends on dim.
  
public:
  CmdPickBase(Cmdtype c, char *cmdname,
  	int b, int m, int d, float x, float y, float z, int uiid);
};


//////////// start picking an object
class CmdPickStart : public CmdPickBase {

protected:
  virtual int do_execute(void) ;

public:
  // constructor 1: 2D
  CmdPickStart(int b, int m, float x, float y, int fromUIid = -1) :
    CmdPickBase(Command::PICK_START, "start", b, m, 2, x, y, 0.0, fromUIid) { }

  // constructor 2: 3D
  CmdPickStart(int b, int m, float x, float y, float z, int fromUIid = -1) :
    CmdPickBase(Command::PICK_START, "start", b, m, 3, x, y, z, fromUIid) { }
};


//////////// end picking an object
class CmdPickEnd : public CmdPickBase {

protected:
  virtual int do_execute(void) ;

public:
  // constructor 1: 2D
  CmdPickEnd(int b, int m, float x, float y, int fromUIid = -1) :
    CmdPickBase(Command::PICK_END, "end", b, m, 2, x, y, 0.0, fromUIid) { }

  // constructor 2: 3D
  CmdPickEnd(int b, int m, float x, float y, float z, int fromUIid = -1) :
    CmdPickBase(Command::PICK_END, "end", b, m, 3, x, y, z, fromUIid) { }
};


//////////// move during a picking operation
class CmdPickMove : public CmdPickBase {

protected:
  virtual int do_execute(void) ;

public:
  // constructor 1: 2D
  CmdPickMove(int b, int m, float x, float y, int fromUIid = -1) :
    CmdPickBase(Command::PICK_MOVE, "move", b, m, 2, x, y, 0.0, fromUIid) { }

  // constructor 2: 3D
  CmdPickMove(int b, int m, float x, float y, float z, int fromUIid = -1) :
    CmdPickBase(Command::PICK_MOVE, "move", b, m, 3, x, y, z, fromUIid) { }
};

#endif
