/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdColor.C,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1994/12/06 08:36:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for affecting molecules.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: CmdColor.C,v $
 * Revision 1.1  1994/12/06  08:36:55  billh
 * Initial revision
 *
 ***************************************************************************/
#ifdef ARCH_HPUX9
  static char ident[] = "@(#)$Header: /Home/h2/billh/projects/vmd/src/RCS/CmdColor.C,v 1.1 1994/12/06 08:36:55 billh Exp $";
#endif

#include <string.h>
#include "CmdColor.h"
#include "ColorList.h"
#include "Scene.h"
#include "DisplayDevice.h"
#include "Global.h"
#include "utilities.h"


// the following defines commands for the Cmdtypes:
// COLOR_NAME, COLOR_CHANGE, COLOR_SCALE_METHOD, COLOR_SCALE_MIDPOINT,
// COLOR_SCALE_MIN, COLOR_SCALE_MAX


//////////////////  utility routines

// given a string which is either a color name or number, return regular
// color index.  If error, return < 0 and print message.
int find_color_index(char *cname) {
  int retval = (-1);

  if(colors)
    retval = colors->colorNames.typecode(cname);

  if(retval < 0)
    msgErr << "Unknown color name '" << cname << "'." << sendmsg;
  
  return retval;
}


//////////////////  commands

///////////////  change the color index for a specifed name in a specified
///////////////  category
int CmdColorName::do_execute(void) {
  int retval;
  if(retval = (colCatIndex >= 0 && colNameIndex >= 0)) {
    if(newColor >= 0) {
      // change color associated with name
      (colors->color_category(colCatIndex))->set_data(colNameIndex, newColor);

      // tell the displayables and the display a color has been changed
      scene->color_changed(colors, colCatIndex);
      display->color_changed(colors, colCatIndex);
    } else {
      int curclr = (colors->color_category(colCatIndex))->data(colNameIndex);
      msgInfo << "Color of " <<(colors->color_categories()).name(colCatIndex);
      msgInfo << " ";
      msgInfo << (colors->color_category(colCatIndex))->name(colNameIndex);
      msgInfo << " is " << colors->colorNames.name(curclr);
      msgInfo << " (" << curclr << ")" << sendmsg;
    }
  }
  
  return retval;
}

// constructor: category name, item name, new color
CmdColorName::CmdColorName(char *cCat, char *cName, char *cCol, int newUIid)
	: Command(Command::COLOR_NAME, newUIid) {
  colNameIndex = newColor = (-1);
  if(colors) {
    colCatIndex = (colors->color_categories()).typecode(cCat);
    if(colCatIndex < 0) {
      msgErr << "Unknown color category '" << cCat << "'." << sendmsg;
    } else {
      colNameIndex = (colors->color_category(colCatIndex))->typecode(cName);
      if(colNameIndex < 0) {
         msgErr << "Unknown name '" << cName << "' for which to set color."
	 	<< sendmsg;
      } else {
        newColor = find_color_index(cCol);
      }
    }
  }
  
  *cmdText << "color " << cCat << " " << cName;
  if(cCol)
    *cmdText << " " << cCol;
  *cmdText << ends;
}


///////////////  change the rgb settings for a specified color
int CmdColorChange::do_execute(void) {
  int retval;
  if(retval = (colIndex >= 0 && (useRGB || newColIndex >= 0))) {
    if(setDefault) {
      colors->reset_color(REGCOLOR(colIndex));
    } else {
      if(useRGB) {
        colors->change_color(REGCOLOR(colIndex), newR, newG, newB);
      } else {
        float *curcol = colors->color(REGCOLOR(newColIndex));
        colors->change_color(REGCOLOR(colIndex),
      				curcol[0], curcol[1], curcol[2]);
      }
    }
  }
  return retval;
}

// constructor 1: color name, R, G, B
CmdColorChange::CmdColorChange(char *cCol, float r, float g, float b,
	int newUIid) : Command(Command::COLOR_CHANGE, newUIid) {
  newColIndex = (-1);
  useRGB = TRUE;
  setDefault = FALSE;
  newR = r;
  newG = g;
  newB = b;
  colIndex = find_color_index(cCol);
  
  *cmdText << "color change " << cCol << " " << r << " " << g << " " << b;
  *cmdText << ends;
}

// constructor 2: color name, color to use for settings
CmdColorChange::CmdColorChange(char *cCol, char *cCol2, int newUIid)
	: Command(Command::COLOR_CHANGE, newUIid) {
  useRGB = FALSE;
  setDefault = FALSE;
  colIndex = find_color_index(cCol);
  if(colIndex >= 0)
    newColIndex = (colIndex >= 0 ? find_color_index(cCol2) : (-1));
  
  *cmdText << "color change " << cCol << " " << cCol2 << ends;
}


// constructor 3: color name, nothing else ... resets color to
// build-in default value
CmdColorChange::CmdColorChange(char *cCol, int newUIid)
	: Command(Command::COLOR_CHANGE, newUIid) {
  setDefault = TRUE;
  colIndex = find_color_index(cCol);
  
  *cmdText << "color change " << cCol << ends;
}


///////////////  change the method used to calculate the color scale
int CmdColorScaleMethod::do_execute(void) {
  int retval;
  if(retval = (colors != NULL && newMethod >= 0))
    colors->scale_method(newMethod);
  return retval;
}

// constructor: new method
CmdColorScaleMethod::CmdColorScaleMethod(int nm, int newUIid)
	: Command(Command::COLOR_SCALE_METHOD, newUIid) {
  newMethod = nm;
  *cmdText << "color scale method " << colorScaleMethod[newMethod] << ends;
}


///////////////  change the midpoint of the color scale
int CmdColorScaleMidpoint::do_execute(void) {
  int retval;
  if(retval = (colors != NULL))
    colors->scale_midpoint(newval);
  return retval;
}

// constructor: new val
CmdColorScaleMidpoint::CmdColorScaleMidpoint(float nv, int newUIid)
	: Command(Command::COLOR_SCALE_MIDPOINT, newUIid) {
  newval = nv;
  *cmdText << "color scale midpoint " << newval << ends;
}


///////////////  change the minimum color of the color scale range
int CmdColorScaleMin::do_execute(void) {
  int retval;
  if(retval = (colors != NULL))
    colors->scale_min(newval);
  return retval;
}

// constructor: new val
CmdColorScaleMin::CmdColorScaleMin(float nv, int newUIid)
	: Command(Command::COLOR_SCALE_MIN, newUIid) {
  newval = nv;
  *cmdText << "color scale min " << newval << ends;
}


///////////////  change the maximum color of the color scale range
int CmdColorScaleMax::do_execute(void) {
  int retval;
  if(retval = (colors != NULL))
    colors->scale_max(newval);
  return retval;
}

// constructor: new val
CmdColorScaleMax::CmdColorScaleMax(float nv, int newUIid)
	: Command(Command::COLOR_SCALE_MAX, newUIid) {
  newval = nv;
  *cmdText << "color scale max " << newval << ends;
}

