// a CAVE specific display device for VMD

#ifndef CAVEDISPLAYDEVICE_H
#define CAVEDISPLAYDEVICE_H

#include "GLRenderer.h"
#include "Inform.h"

static char *caveStereoNameStr[1] = {"Cave"};


class CaveDisplayDevice : public GLRenderer {

private:
  // have we initialized the graphics yet?
  int doneGLInit;

public:
  CaveDisplayDevice(void) : GLRenderer("Cave") {
    MSGDEBUG(1, "Creating CaveDisplayDevice ... " << sendmsg);
    
    stereoNames = caveStereoNameStr;
    stereoModes = 1;
    doneGLInit = FALSE;    
    
    // leave everything else up to the cave_gl_init_fn
  }
  
  virtual ~CaveDisplayDevice(void) {  // do diddley
  }
  
  // set up the graphics on the seperate CAVE displays
  void cave_gl_init_fn(void) {
    
    msgWarn << "CaveDisplayDevice: initializing graphics ..." << sendmsg;

    has2D = FALSE;  //  not that we even _have_ 2D stuff now
    aaAvailable = (getgdesc(GD_PNTSMOOTH_RGB) && getgdesc(GD_LINESMOOTH_RGB));
    cueingAvailable = FALSE;
    

    RGBmode();
    gconfig();
    zbuffer(1);
    glcompat(GLC_ZRANGEMAP, 0);
    lsetdepth(getgdesc(GD_ZMIN),getgdesc(GD_ZMAX));
    backface(FALSE);
    shademodel(GOURAUD);
    mmode(MVIEWING);
    subpixel(TRUE);

    // define graphics state based on already-set default values
#ifndef __NPGL__
    sphmode(SPH_HEMI,TRUE);
    sphmode(SPH_ORIENT,TRUE);
    sphmode(SPH_TESS,SPH_OCT);
#endif
    set_sphere_mode(sphereMode);
    set_sphere_res(sphereRes);
    set_line_width(lineWidth);
    set_line_style(lineStyle);

    msgWarn << "CaveDisplayDevice: defining lights ..." << sendmsg;
    // turn on lights if necessary
    for(int i=0; i < DISP_LIGHTS; i++) {
      if(lightDefined[i]) {
	do_define_light(i, lightColor[i], lightPos[i]);
	do_activate_light(i, lightOn[i]);
      } else
	do_activate_light(i, FALSE);
    }
    // define the light model ... this never changes.
    // material display is turned on/off by binding MATERIALS.
    lmdef(DEFLMODEL,1,0,(float *)NULL);
    lmbind(LMODEL, 1);

    msgWarn << "CaveDisplayDevice: defining materials ..." << sendmsg;

    // define materials if necessary
    for(i=0; i < MAXCOLORS; i++) {
      if(matDefined[i])
	do_define_material(i, matData[i]);
    }
    do_activate_material(materialOn, materialsActive);
    
    // we want the CAVE to be centered at the origin, and in the range
    // -1, +1
    (transMat.top()).translate(0.0, 3.0, -2.0);
    (transMat.top()).scale(PI);
    
    // turn on antialiasing and depth-cueing off
    aa_on();
    cueing_off();
  }
  
  // cannot change to stereo mode
  virtual void set_stereo_mode(int = 0) {
  };
  
  // routines to prepare, draw, and finish, some done by the CAVE
  virtual void prepare2D(int ){}                // ready to draw 2D
  virtual void prepare3D(int do_clear){         // ready to draw 3D
    if(do_clear)
      clear();
     else
      zclear();
  }
  virtual void clear(void){                     // erase the device
    unsigned long l;
    l = ( ( (short)(backColor[0] * 255.0) ) |
        ( (short)(backColor[1] * 255.0) << 8) |
        ( (short)(backColor[2] * 255.0) << 16) );
    czclear(l, getgdesc(GD_ZMAX));
  }

  virtual void left(void){}                     // ready to draw left eye
  virtual void right(void){}                    // ready to draw right eye
  virtual void normal(void){}                   // ready to draw non-stereo
  virtual void update(int ){}                   // finish up after drawing
  virtual void reshape(void){}                  // refresh device after change
  
  // special render routine to check for graphics initialization
  virtual void render(void *cmdlist) {
    if(!doneGLInit) {
      cave_gl_init_fn();
      doneGLInit = TRUE;
    }

    // now do regular rendering
    push();
    multmatrix((transMat.top()));
    GLRenderer::render(cmdlist);
    pop();
  }

};

#endif
