/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Axes.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/02/22 03:57:58 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A Displayable3D object which consists of a set of axes, which may be
 * drawn anywhere on the screen, at any size.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Axes.h,v $
 * Revision 1.5  1995/02/22  03:57:58  billh
 * Now supports picking objects with a 2D or 3D pointer.
 * Now a Pickable, and allows the user to moves the axes with the mouse in
 * all pick modes.
 *
 * Revision 1.4  94/12/06  08:24:25  billh
 * Added ability to create color categories, due to being now derived from
 * ColorUser.
 * Added routines to have a new color list specified, and to check for when
 * a color in a relevant category is changed.
 * 
 * Revision 1.3  94/09/29  06:51:39  billh
 * Changed location() routine to be inline.
 * 
 * Revision 1.2  1994/09/24  20:29:47  billh
 * Now contain single display commands which are used many times,
 * >> instead of re-creating and destroying disp command object.
 *
 * Revision 1.1  1994/08/24  03:10:37  billh
 * Initial revision
 *
 ***************************************************************************/
#ifndef AXES_H
#define AXES_H

#include "Displayable.h"
#include "DispCmds.h"


class Axes : public Displayable3D {

public:
  // locations for the axes
  enum AxesPos { NO_AXES = 0, AXES_ORIGIN, AXES_LOWERLEFT, 
  	AXES_LOWERRIGHT, AXES_UPPERLEFT, AXES_UPPERRIGHT, AXESPOS_TOTAL };

private:
  // lines defining the axes
  float origin[3], xLine[3], yLine[3], zLine[3];
  float xLineCap[3], yLineCap[3], zLineCap[3];
  float xText[3], yText[3], zText[3];

  // current axes position
  int axesPos;
  
  // most recent aspect ratio of the display
  float Aspect;

  // integer for color category with the colors to use.  If < 0, use
  // default colors
  int colorCat;

  // useful display command objects
  DispCmdSphereRes sphres;
  DispCmdSphereType sphtype;
  DispCmdMaterials cmdMaterials;
  DispCmdColorIndex xcol;
  DispCmdCylinder xcyl;
  DispCmdCone xcap;
  DispCmdSphere sph;
  DispCmdTextPos txtpos;
  DispCmdText xtxt;
  DispCmdText ytxt;
  DispCmdText ztxt;
  DispCmdPickPoint pickPoint;

  // regenerate the command list, and flag for saying we need to do so
  int need_create_cmdlist;
  void create_cmdlist(void);

  // have we moved the axes with the pointer?
  int movedAxes;

protected:
  // do action when a new color list is provided
  virtual void do_use_colors(void);

  // do action due to the fact that a color for the given ColorList for
  // the specified category has changed
  virtual void do_color_changed(ColorList *, int);

public:
  // constructor: the Scene to register this with
  Axes(Scene *);
  virtual ~Axes(void) { }

  // set axes display mode; return success
  int location(int);

  // return axes display mode
  int location(void) { return axesPos; }

  // return descripton of location
  char *loc_description(int);

  // return total number of locations
  int locations(void) { return AXESPOS_TOTAL; }

  //
  // public virtual drawing routines
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  virtual void prepare(DisplayDevice *);

  //
  // public virtual picking routines
  //

  // return if we are interested in the given pick mode or not ... here, we
  // are interested in ALL modes
  virtual int want_pick_mode(int) { return TRUE; }

  // called when a pick moves:
  //	args = display to use, obj picked, button, mode, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  // For the Axes, when they are selected and the pointer moves, we wish
  // to move the axes as well.
  virtual void pick_move(DisplayDevice *, Pickable *,
  				int, int, int, int, float *);
  
  // we do NOT need a special version of pick_start or pick_end in this case.

};

#endif
