/*
 * Copyright (C) 2007 by David J. Hardy.  All rights reserved.
 *
 * timer.c
 */

#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include "timer.h"

/*
 * Note: gettimeofday() is low resolution for performance timing,
 * in the sense that it measures wall clock time, not process time.
 */
void timer_start(Timer *t)
{
  struct timeval v;
  gettimeofday(&v, NULL);
  t->seconds = (double) v.tv_sec;
  t->fraction = (double) v.tv_usec;
}

/*
 * Reduce roundoff error by differencing components before combining.
 */
double timer_delta(Timer *t)
{
  struct timeval v;
  gettimeofday(&v, NULL);
  return ((double) v.tv_sec - t->seconds)
    + 1e-6*((double) v.tv_usec - t->fraction);
}
