
/* 
 * work horse part the 'gofr' command.
 * 
 * Copyright (c) 2004 axel.kohlmeyer@theochem.ruhr-uni-bochum.de
 */

#include <math.h> /* for sqrt() */

#include "gofr.h"

/* find the minimum image distance for one coordinate component and square the result. */
static double fix_pbc_n_sqr(double delta, const double boxby2)
{
    while (delta >  boxby2) { delta -= 2.0 * boxby2; }
    while (delta < -boxby2) { delta += 2.0 * boxby2; }
    return delta * delta;
}

/* calculate the minimum distance between two positions with respect to the PBC. */
static double min_dist_with_pbc(const coord a, const coord b, const coord boxby2)
{
    double distsqr;
    distsqr  = fix_pbc_n_sqr(a.x - b.x, boxby2.x);
    distsqr += fix_pbc_n_sqr(a.y - b.y, boxby2.y);
    distsqr += fix_pbc_n_sqr(a.z - b.z, boxby2.z);
    return sqrt(distsqr);
}

/* calculate the non-normalized pair-distribution function
   for two lists of atom coordinates and store the resulting
   histogram in the hlist array. */
void calc_gofr(const int count_a, const coord *alist, 
              const int count_b, const coord *blist, 
              const int count_h, int *hlist, 
              const double delta, const coord boxby2)
{
    int i, j, idx;
    double dist;

    for (i=0; i<count_a; ++i) {
        for (j=0; j<count_b; ++j) {
            dist = min_dist_with_pbc(alist[i], blist[j], boxby2);
            idx = (int) (dist/delta + 0.5);
            if ((idx >= 0) && (idx < count_h)) ++hlist[idx];
        }
    }
    return;
}
