#include <tcl.h>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <vector>

#include "VMDApp.h"
#include "MoleculeList.h"

extern "C" {
int Carray_Init(Tcl_Interp *interp);
}
static int obj_carray(ClientData cd, Tcl_Interp *interp, int argc, Tcl_Obj * const objv[]);

static int obj_carray(ClientData cd, Tcl_Interp *interp, int argc, Tcl_Obj * const objv[])
{
  int molid = -1;  // default : top
  int frame = -1;  // default : current frame
  VMDApp *app = (VMDApp *)Tcl_GetAssocData(interp, (char *)"VMDApp", NULL);
  // ultimately: Molecule *mol = app->moleculeList->mol_from_id(molid);
  Molecule *mol = app->moleculeList->top();

  printf ("Number of molecules: %i\n", app->moleculeList->num());
  printf ("Top molecule: %p\n", app->moleculeList->top());

  if (!mol) {
    Tcl_SetResult(interp, (char *) "invalid molecule ID", TCL_STATIC);
    return TCL_ERROR;
  }

  Timestep *ts = NULL;
  /*
  if (frame == -1) {
    ts = mol->current();
  } else if (frame == -2) {
    ts = mol->get_last_frame();
  } else {
    ts = mol->get_frame(frame);
  }
  */
  ts = mol->get_frame(0);

  if ( ts == NULL ) {
    Tcl_SetResult(interp, (char *) "timestep not found", TCL_STATIC);
    return TCL_ERROR;
  }
  printf ("mol = %p   frame 0s = %p   ts->pos = %p\n", mol, ts, ts->pos);
  printf ("numframes = %i\n", mol->numframes());

  if ( ts->pos == NULL ) {
    Tcl_SetResult(interp, (char *) "timestep: no data", TCL_STATIC);
    return TCL_ERROR;
  }
  /*
  if (argc < 2) {
    Tcl_WrongNumArgs(interp, 1, objv, (char *)"pointer");
    return TCL_ERROR;
  }

  long    temp;

  if (Tcl_GetLongFromObj(interp, objv[1], &temp) != TCL_OK) {
    Tcl_SetResult(interp, (char *) "error parsing long int argument", TCL_STATIC);
    return TCL_ERROR;
  }

  if ( temp == 0 ) {
    Tcl_SetResult(interp, (char *) "got NULL pointer", TCL_STATIC);
    return TCL_ERROR;
  }

  float *p = (float *) temp;

  p[0] += 5.0;
*/

  float *p = ts->pos;
  printf ("p = %p, long %li\n", p, (long) p);
  for (int i = 0; i<10; i++) {
//    p[i] = 0.0;
  }

  return TCL_OK;
}

extern "C" {
  int Carray_Init(Tcl_Interp *interp) {
    Tcl_CreateObjCommand(interp, "c_array", obj_carray,
                    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    return TCL_OK;
  }
}

