# molywood-gui



## What is Molywood?

Molywood is a standalone Python library developed at IRB Barcelona to accelerate movie-making in VMD, thoroughly described and documented [here](https://mmb.irbbarcelona.org/molywood/). Before using the GUI, please install Molywood on your system - if your system has Python+numpy/matplotlib, imagemagick, and ffmpeg, this can be as simple as `pip install molywood`. Optionally, you can also quick-install these dependencies directly from the GUI in VMD.

## What does this GUI do?

This TCL graphical interface brings advanced movie-making to your desktop version of VMD, starting from VMD 2.0 (built-in) and 1.9.4-beta (installable). Its advantages include:

    - dropdown menus with all available actions and parameters: no need to learn the syntax
    - integrated previews: no need to restart VMD each time you want to preview the movie
    - templates: load your system and choose a customizable way to present the interesting bits
    - diagrams and dynamic highlights: see the movie layout on a timeline, and follow actions in real time
  
## How to install it, if my VMD version does not have it?

In a chosen directory, get the plugin by running:

```
git clone https://gitlab.com/milafternoon/molywood-gui.git
```

This will create the subdirectory `molywood-gui` containing the Tcl library. 
On Linux/Mac, use the following command to put the path into the .vmdrc file that controls VMD settings upon startup:

```
cd molywood-gui
echo "lappend auto_path $(pwd)" >> ~/.vmdrc
```

This adds the current working directory to the locations where VMD looks for packages. Then, from the Tcl console in VMD, you should be able to run:

```
package require molywood
```

which should start up the GUI window. If you want to restart it after closing, type `molywood-gui` in the Tk console.

**NOTE**: In some versions of VMD, there is a bug that prevents the main VMD menu from displaying when only such a minimal `.vmdrc` is present. 
If that's the case, simply add `menu main on` below in your `~/.vmdrc`.

Make sure you're running the latest version of VMD - the library might not work on pre-1.9.4 versions on Linux (with Tcl 8.5 or older)! VMD 2.0 and 1.9.4-beta are shipped with the latest Tcl libraries.

You can also put the first line (`package...`) in your .vmdrc - this way you won't have to repeat it each time!

## How do I get started?

[Video tutorials](https://www.youtube.com/watch?v=7rHwlxm3d00&list=PLl6-JGevY8O1bExfakK8yr-sczsuBjooV) are available on Youtube in the form of short, ca. 5-minute clips introducing key workflows and features.

## Can I request new features?

A large part of Molywood's development has been driven by users' feedback. If you find bugs or have ideas for missing features, let us know! To suggest modifications, ask for guidance or report undesired behavior, get in touch with Miłosz Wieczór at milosz.wieczor@irbbarcelona.org.

## How do I get the latest version?

Make sure your Molywood is up-to-date: we periodically update the pip repository, but the latest (not necessarily thoroughly tested) version is available at GitLab.
To get the latest version of Molywood, git-clone [the Molywood repository](https://gitlab.com/KomBioMol/molywood), enter the directory, and type `pip install .` (make 
sure you have the correct conda environment activated!).

If you installed Molywood-GUI in the above way, just go to the original directory and type `git pull` - the latest `.tcl` scripts will be downloaded and visible to VMD.

## Troubleshooting

#### I installed `molywood-gui` and now VMD does not show the main menu. Is something broken?

In some VMD versions, a near-empty `~/.vmdrc` can overwrite the default `menu main on` command. Add it below the auto_path line `main menu on` in `~/.vmdrc` and it will return.

#### I'm using `tcsh`/`zsh`/`csh` in my terminal as a default, and because of that VMD cannot locate `conda`. What can I do?

Here's a `conda` wrapper that you can use to work around this:

```
#!/usr/local/bin/bash
source ~/.bashrc
unset PYTHONHOME
unset PYTHONPATH
which conda
conda "$@"
```

#### I'm working on Windows and Molywood-GUI doesn't run. Are there workarounds?

While Molywood itself can be run on Windows, the automatic installation tools don't yet work on Windows. We're working on solutions that will require manual installation of dependencies.