
eval {

set argv {}
set argc [llength $argv]

foreach {dir} {/Projects/namd2/Programmers/jim/swift/turbine/lib} {
  source $dir/pkgIndex.tcl
}

set worker_index $env(PMI_RANK)

package provide vmdswift 0.1

proc swift_proc { typed_outputs name typed_inputs body } {
  foreach i [lsearch -exact -all $typed_outputs int] { if { $i % 2 == 0 } { lset typed_outputs $i integer } }
  foreach i [lsearch -exact -all $typed_inputs int] { if { $i % 2 == 0 } { lset typed_inputs $i integer } }
  set body_args {}
  set output_code ""
  foreach { type arg } $typed_outputs {
    lappend body_args __swift_proc_output_$arg
    set output_code "${output_code}store_$type \$__swift_proc_output_$arg \$$arg; "
  }
  set input_code " set __swift_proc_typed_outputs [list $typed_outputs];"
  foreach { type arg } $typed_inputs {
    lappend body_args $arg
    set input_code "${input_code} set $arg \[ retrieve_$type \$$arg \];"
  }

  set rule1 {rule $inputs [concat }
  set rule2 "[uplevel namespace current]::"
  set rule3 {_body $outputs $inputs] type $turbine::WORK}
  set rule $rule1$rule2$name$rule3
  set fullbody "$input_code$body\n$output_code"
  puts [list proc $name { outputs inputs } $rule]
  puts [list proc ${name}_body $body_args $fullbody]
  uplevel [list proc $name { outputs inputs } $rule]
  uplevel [list proc ${name}_body $body_args $fullbody]
}

proc swift_return { args } {
  upvar __swift_proc_typed_outputs typed_outputs
  foreach { type arg } $typed_outputs val $args {
    upvar __swift_proc_output_$arg __swift_proc_output_local
    store_$type $__swift_proc_output_local $val
  }
  return -code return
}

namespace eval vmdswift {

# example copied from NAMD

swift_proc {string o} run {string i int k int n string s} {
  global worker_index
  puts "Worker $worker_index running $i for $n steps to $o"
  eval $s
  # ::run $n
  swift_return $o
  error "this should never happen"
}

}

source hello.tcl

}

