
set ntraj 511
set ifile /Projects/namd2/Programmers/jim/benchmark/apoa1/apoa1_init

set output_root /ssd/jim/output

set num_replicas 32
set num_runs 16
set steps_per_run 60
set min_temp 200
set max_temp 400

set argv {}
set argc [llength $argv]

#set tcl_library /usr/share/tcl8.5
#source /usr/share/tcl8.5/init.tcl
# No! - overrides NAMD unknown command
# Take only the bit of the file we actually need:

namespace eval tcl {
    namespace eval mathfunc {
        proc min {args} {
            if {[llength $args] == 0} {
                return -code error \
                    "too few arguments to math function \"min\""
            }
            set val Inf
            foreach arg $args {
                # This will handle forcing the numeric value without
                # ruining the internal type of a numeric object
                if {[catch {expr {double($arg)}} err]} {
                    return -code error $err
                }
                if {$arg < $val} { set val $arg }
            }
            return $val
        }
        proc max {args} {
            if {[llength $args] == 0} {
                return -code error \
                    "too few arguments to math function \"max\""
            }
            set val -Inf
            foreach arg $args {
                # This will handle forcing the numeric value without
                # ruining the internal type of a numeric object
                if {[catch {expr {double($arg)}} err]} {
                    return -code error $err
                }
                if {$arg > $val} { set val $arg }
            }
            return $val
        }
        namespace export min max
    }
}

foreach {dir} {/Projects/namd2/Programmers/jim/swift/turbine/lib} {
  source $dir/pkgIndex.tcl
}

if { [numReplicas] == 1 } {
  set replica_index $env(PMI_RANK)
} else {
  set replica_index [myReplica]
}

set SEED [expr ((1009 * $replica_index) % 2000) * 100000 + int(100000 * rand())];
seed $SEED
expr srand($SEED)
puts "seed $SEED"

package provide namdswift 0.1

proc swift_proc { typed_outputs name typed_inputs body } {
  foreach i [lsearch -exact -all $typed_outputs int] { if { $i % 2 == 0 } { lset typed_outputs $i integer } }
  foreach i [lsearch -exact -all $typed_inputs int] { if { $i % 2 == 0 } { lset typed_inputs $i integer } }
  set body_args {}
  set output_code ""
  foreach { type arg } $typed_outputs {
    lappend body_args __swift_proc_output_$arg
    set output_code "${output_code}store_$type \$__swift_proc_output_$arg \$$arg; "
  }
  set input_code " set __swift_proc_typed_outputs [list $typed_outputs];"
  foreach { type arg } $typed_inputs {
    lappend body_args $arg
    set input_code "${input_code} set $arg \[ retrieve_$type \$$arg \];"
  }

  set rule1 {rule $inputs [concat }
  set rule2 "[uplevel namespace current]::"
  set rule3 {_body $outputs $inputs] type $turbine::WORK}
  set rule $rule1$rule2$name$rule3
  set fullbody "$input_code$body\n$output_code"
  puts [list proc $name { outputs inputs } $rule]
  puts [list proc ${name}_body $body_args $fullbody]
  uplevel [list proc $name { outputs inputs } $rule]
  uplevel [list proc ${name}_body $body_args $fullbody]
}

proc swift_return { args } {
  upvar __swift_proc_typed_outputs typed_outputs
  foreach { type arg } $typed_outputs val $args {
    upvar __swift_proc_output_$arg __swift_proc_output_local
    store_$type $__swift_proc_output_local $val
  }
  return -code return
}

namespace eval namdswift {

swift_proc {string o} run {string i int k int n string s} {
  global replica_index output_index output_root
  set o $output_root.$k
  stdout $o.log
  puts "Replica $replica_index running $i for $n steps to $o"
  firsttimestep 0
  reinitatoms $i
  eval $s
  ::run $n
  output $o
  swift_return $o
  error "this should never happen"
}

proc save_callback {labels values} {
  global saved_labels saved_values
  set saved_labels $labels
  set saved_values $values
}
callback namdswift::save_callback

proc save_array {} {
  global saved_labels saved_values saved_array
  foreach label $saved_labels value $saved_values {
    set saved_array($label) $value
  }
  print "save_array [namespace current] $saved_array(POTENTIAL)"
}

swift_proc {string o float POTENTIAL} run_t {string i int r int f int n float NEWTEMP float OLDTEMP} {
  global replica_index output_index output_root saved_array steps_per_run
  set o $output_root.$r.$f
  # stdout $o.log
  puts "Replica $replica_index running $i for $n steps to $o"
  firsttimestep [expr ($f-1)*$steps_per_run]
  reinitatoms $i
  rescalevels [expr sqrt(1.0*$NEWTEMP/$OLDTEMP)]
  langevinTemp $NEWTEMP
  ::run $n
  output $o
  save_array
  swift_return $o $saved_array(POTENTIAL)
  error "this should never happen"
}

}

