#!/bin/sh

K=3
#Loop over L truncation
mkdir -p Exercise3.output
cd Exercise3.output
for L in 5 7 9 11 13
do
  filename=TLS-Dynamics_77K_L${L}K${K}
  cat > $filename.prm << ENDINPUT
OutputFile=$filename.out
NumStates=2
HierarchyTruncation=$L
Temperature=77
MatsubaraTerms=$K
Hamiltonian:
100,200
200,-0
InitialDensityMatrix:
1.0,0.0
0.0,0.0
gamma:
10,10
lambda:
300,300
Timestep=0.0001
Time=1.0
ENDINPUT
  phi $filename.prm rkf45 4 > $filename.log
  sed -e '/^\#/d' -e 's/(//g' -e 's/)//g ' -e 's/,/ /g' $filename.out | awk ' { print $1" "$2 } ' > ${filename}_00.out
done

gnuplot << ENDINPUT
set term post enhanced eps solid color lw 6.0 "Helvetica" 24
set out "LDynamics.eps"
set multiplot
set origin 0,0
set size 1,1

set xrange [0:1] 
set yrange [0.2:1]

set xtics 0,0.2,1.0
set ytics 0,0.1,1.0

set key top left

set border 31 lw 0.4
set xlabel "t (ps)"
set ylabel "{/Symbol-Oblique r}_{00}(t)"

p "./TLS-Dynamics_77K_L5K3_00.out"  w l lc rgb "red" lw 1.0 ti "L=5",\
  "./TLS-Dynamics_77K_L7K3_00.out"  w l lc rgb "green" lw 1.0 ti "L=7",\
  "./TLS-Dynamics_77K_L9K3_00.out"  w l lc rgb "royalblue" lw 1.0 ti "L=9",\
  "./TLS-Dynamics_77K_L11K3_00.out" w l lc rgb "orange" lw 1.0 ti "L=11",\
  "./TLS-Dynamics_77K_L13K3_00.out" w l lc rgb "black" lw 1.0 ti "L=13"




set origin 0.4,0.4
set size 0.55,0.55

set xrange [0.9:1] 
set yrange [0.28:0.31]

set xtics 0.9,0.05,1.0
set ytics 0.,0.01,0.45

unset key
unset ylabel 
unset xlabel
p "./TLS-Dynamics_77K_L5K3_00.out" w l lc rgb "red" lw 1.0 ti "L=5",\
  "./TLS-Dynamics_77K_L7K3_00.out" w l lc rgb "green" lw 1.0 ti "L=7",\
  "./TLS-Dynamics_77K_L9K3_00.out" w l lc rgb "royalblue" lw 1.0 ti "L=9",\
  "./TLS-Dynamics_77K_L11K3_00.out" w l lc rgb "orange" lw 1.0 ti "L=11",\
  "./TLS-Dynamics_77K_L13K3_00.out" w l lc rgb "black" lw 1.0 ti "L=13"



unset multiplot
ENDINPUT
