#/bin/csh

##
## Script for building plugins on all supported platforms
##
#setenv DATE `date +%Y-%m-%d-%T`
setenv DATE `date +%m%d-%H%M%S`

##
## BioCoRE logging (eventually, need other changes first)
##
#setenv BUILDNUM `cat /Projects/vmd/vmd/vmdbuild.number`;
#setenv LOGRUN  'biolog -f -p vmd -k "VMD plugins build $BUILDNUM, BUILD SUMMARY" -s "VMD build $BUILDNUM, BUILD SUMMARY"'
#setenv LOGGING 'biolog -f -p vmd -k "VMD plugins build $BUILDNUM, Platform: $1"  -s "VMD build $BUILDNUM, Platform: $1"'

setenv unixdir `pwd` 
setenv windir /cygdrive/j/plugins

## MacOS X 10.2 framework paths
setenv TCLINC -I/Projects/vmd/vmd/lib/tcl/include
setenv TCLLIB -F/Projects/vmd/vmd/lib/tcl

ssh -x cupertino "cd $unixdir; gmake MACOSX TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_MACOSX >& log.MACOSX.$DATE " < /dev/null &

## include/link paths for rest of the unix platforms
setenv TCLINC -I/Projects/vmd/vmd/lib/tcl/include
setenv TCLLIB -L/Projects/vmd/vmd/lib/tcl
ssh -x beirut "cd $unixdir; gmake AIX4 TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_AIX4 >& log.AIX4.$DATE " < /dev/null &

ssh -x madrid "cd $unixdir; gmake LINUX TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_LINUX >& log.LINUX.$DATE " < /dev/null &

ssh -x titan "cd $unixdir; gmake IRIX6 TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_IRIX6 >& log.IRIX6.$DATE" < /dev/null &

ssh -x cancun "cd $unixdir; gmake SOLARIS2 TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_SOLARIS2 >& log.SOLARIS2.$DATE" < /dev/null &

ssh -x cancun "cd $unixdir; gmake SOLARIS2_64 TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_SOLARIS2_64 >& log.SOLARIS2_64.$DATE" < /dev/null &

ssh -x ganymede "cd $unixdir; gmake HPUX11 TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_HPUX11 >& log.HPUX11.$DATE" < /dev/null &

ssh -x galatea "cd $unixdir; gmake TRU64 TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_TRU64 >& log.TRU64.$DATE" < /dev/null &

## Win32 include/link paths
setenv TCLINC -IJ:/vmd/lib/tcl/include
setenv TCLLIB /LIBPATH:J:/vmd/lib/tcl
ssh -x -l administrator malta "cd $windir; make WIN32 TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_WIN32 >& log.WIN32.$DATE" < /dev/null &

echo "Waiting for all first round jobs to complete..."
wait

echo "Building second round jobs, avoiding compiler locking problems."

## finish up last Unix builds
setenv TCLINC -I/Projects/vmd/vmd/lib/tcl/include
setenv TCLLIB -L/Projects/vmd/vmd/lib/tcl
ssh -x titan  "cd $unixdir; gmake IRIX6_64 TCLINC=$TCLINC TCLLIB=$TCLLIB/lib_IRIX6_64 >& log.IRIX6_64.$DATE" < /dev/null &

echo "Waiting for all make jobs to complete..."
wait
