/*****************************************************************************
 * $Source: /cvsroot/charm-5.9/src/ck-ldb/NeighborCommLB.h,v $
 * $Author: zshao1 $
 * $Date: 2003/12/08 03:12:30 $
 * $Revision: 1.1 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

#ifndef _NEIGHBORCOMMLB_H_
#define _NEIGHBORCOMMLB_H_

#include <math.h>

#include "NborBaseLB.h"
#include "NeighborCommLB.decl.h"

void CreateNeighborCommLB();

class NeighborCommLB : public NborBaseLB {
public:
  NeighborCommLB(const CkLBOptions &);
  NeighborCommLB(CkMigrateMessage *m):NborBaseLB(m) {}
private:
  CmiBool QueryBalanceNow(int step) { return CmiTrue; };
  virtual int max_neighbors() {
    return (CkNumPes() > 5) ? 4 : (CkNumPes()-1);
  };
  virtual int num_neighbors() {
    return (CkNumPes() > 5) ? 4 : (CkNumPes()-1);
  };
  virtual void neighbors(int* _n) {
    const int me = CkMyPe();
    const int npe = CkNumPes();
    if (npe > 1)
      _n[0] = (me + npe - 1) % npe;
    if (npe > 2)
      _n[1] = (me + 1) % npe;

    int bigstep = (npe - 1) / 3 + 1;
    if (bigstep == 1) bigstep++;

    if (npe > 3)
      _n[2] = (me + bigstep) % npe;
    if (npe > 4)
      _n[3] = (me + npe - bigstep) % npe;
  };

  LBMigrateMsg* Strategy(NborBaseLB::LDStats* stats, int count);
};

#endif /* _NeighborCommLB_H_ */

/*@}*/
