/*****************************************************************************
 * $Source: /cvsroot/charm-5.9/src/ck-ldb/Comm1LB.h,v $
 * $Author: gzheng $
 * $Date: 2005/01/10 04:20:39 $
 * $Revision: 1.11 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

#ifndef _Comm1LB_H_
#define _Comm1LB_H_

#include <CentralLB.h>
#include "Comm1LB.decl.h"

#include "CommLBHeap.h"
#include "GreedyCommLB.h"

#define CUT_OFF_FACTOR 1.200

void CreateComm1LB();

struct alloc_struct{
  double load;
  int nbyte;
  int nmsg;
};

class Comm1LB : public CentralLB {
public:
  int nobj,npe;
  alloc_struct ** alloc_array;
  graph * object_graph;
  Comm1LB(const CkLBOptions &);
  Comm1LB(CkMigrateMessage *m):CentralLB(m) {}
private:
  CmiBool QueryBalanceNow(int step);
  void work(BaseLB::LDStats* stats, int count);
  void alloc(int pe, int id, double load, int nmsg, int nbyte);
  double compute_cost(int id, int pe, int n_alloc, int &out_msg, int &out_byte); 
  void add_graph(int x, int y, int data, int nmsg);
};

#endif


/*@}*/

