/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import org.apache.commons.digester.Digester;
import org.apache.tomcat.util.IntrospectionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CatalinaDigester
extends Digester {
    protected static IntrospectionUtils.PropertySource[] source = new IntrospectionUtils.PropertySource[]{new SystemPropertySource()};

    public void startElement(String namespaceURI, String localName, String qName, Attributes list) throws SAXException {
        list = this.updateAttributes(list);
        super.startElement(namespaceURI, localName, qName, list);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.bodyText = this.updateBodyText(this.bodyText);
        super.endElement(namespaceURI, localName, qName);
    }

    private Attributes updateAttributes(Attributes list) {
        if (list.getLength() == 0) {
            return list;
        }
        AttributesImpl newAttrs = new AttributesImpl(list);
        int nAttributes = newAttrs.getLength();
        for (int i = 0; i < nAttributes; ++i) {
            String value = newAttrs.getValue(i);
            try {
                String newValue = IntrospectionUtils.replaceProperties((String)value, null, (IntrospectionUtils.PropertySource[])source);
                if (value == newValue) continue;
                newAttrs.setValue(i, newValue);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return newAttrs;
    }

    private StringBuffer updateBodyText(StringBuffer bodyText) {
        String out;
        String in = bodyText.toString();
        try {
            out = IntrospectionUtils.replaceProperties((String)in, null, (IntrospectionUtils.PropertySource[])source);
        }
        catch (Exception e) {
            return bodyText;
        }
        if (out == in) {
            return bodyText;
        }
        return new StringBuffer(out);
    }

    private static class SystemPropertySource
    implements IntrospectionUtils.PropertySource {
        private SystemPropertySource() {
        }

        public String getProperty(String key) {
            return System.getProperty(key);
        }
    }
}

