#include <math.h>
#include <string.h>

#include "vec.h"

const double kNAN = sqrt(-1.);

void vcopy(double *vout, const double *v1) {
  memcpy(vout, v1, 3*sizeof(double));
}

void  vcopy(float *vout, const float *v1) {
  memcpy(vout, v1, 3*sizeof(float));
}


double vnorm(const double *vec) {
  return sqrt(vec[0]*vec[0] + vec[1]*vec[1] + vec[2]*vec[2]);
}

float vnorm(const float *vec) {
  return sqrt(vec[0]*vec[0] + vec[1]*vec[1] + vec[2]*vec[2]);
}


