#include <stdio.h>
#include <stdlib.h>
#include <string.h>


bool do_exp = false;
bool do_log = false;

bool do_trim = false;
bool do_downsample = false;
bool do_downsample_pmf = false;

bool do_collapse = false;
bool do_collapse_pmf = false;

bool do_rotate_avg = false;
bool do_rotate_avg_pmf = false;

bool do_diff = false;
bool do_occup = false;


bool do_combine = false;
bool do_combinepmf = false;

bool do_mult = false;
bool do_sum = false;

bool do_custom1;
bool do_custom2;

double smooth_radius = 0.;
double smooth_radius_pmf = 0.;

long trimxp = -1;
long trimyp = -1;
long trimzp = -1;
long trimxm = -1;
long trimym = -1;
long trimzm = -1;
long trimx = -1;
long trimy = -1;
long trimz = -1;
long trim = -1;

char *outputname = NULL;
char *inputname1 = NULL;
char *inputname2 = NULL;

char **filelist = NULL;
int numinputfiles = 0;

  
static int _slm; //internal use
#define SETPARAM_LONG(X,var) else if (!strncmp(argv[i]+1, (X), _slm=strlen(X))) { \
    if (sscanf(argv[i]+1+_slm, "%ld", &var) <= 0)  \
      sscanf(argv[++i], "%ld", &var); \
      continue; \
    } 

				
#define SETPARAM_DOUBLE(X,var) else if (!strncmp(argv[i]+1, (X), _slm=strlen(X))) { \
    if (sscanf(argv[i]+1+_slm, "%lf", &var) <= 0)  \
      sscanf(argv[++i], "%lf", &var); \
      continue; \
    } 

#define SETPARAM_FLAG(SET,UNSET,var) \
		else if (!strcmp(argv[i]+1, (SET)) && strcmp("", (SET)))  \
		var = 1; \
		else if (!strcmp(argv[i]+1, (UNSET)) && strcmp("", (UNSET)))  \
		var = 0;

#define SETPARAM_STRING(X,var) else if (!strncmp(argv[i]+1, (X), _slm=strlen(X))) { \
    var=argv[i]+1+_slm; \
    if (!strlen(var)) {  \
      var = argv[++i]; \
      continue; \
    } \
  }
  

//char *infostring=NULL;

/* Parse command line
*/	
void ScanCommandLine(int argc, char** argv){
  bool err_too_many_inputs = false;
  bool need_two_inputs = false;
  
  if (argc == 1 || !strcmp(argv[1],"--help")){
    fprintf(stderr, "usage: volmaptool [options] <map1> [map2]\n");
    fprintf(stderr, "map operations:\n");
    fprintf(stderr, "  -downsample|-ds   downsample by x2 (x8 total reduction)\n");
    fprintf(stderr, "  -trim <trim>      trim grid by specified amount in x, y and z\n");
    fprintf(stderr, "  -trimx <x>        trim grid by specified amount in x (or y,z)\n");
    fprintf(stderr, "  -trimxp <x>       trim one side of grid by specified amount in x (or y,z)\n");
    fprintf(stderr, "  -trimxm <x>       trim other side of grid by specified amount in x (or y,z)\n");
    fprintf(stderr, "  -exp              convert pmf to density\n");
    fprintf(stderr, "  -log              convert density to pmf\n");
    fprintf(stderr, "  -smooth <radius>  3D gaussian blur\n");
    fprintf(stderr, "  -collapse         project maps onto z axis\n");
    fprintf(stderr, "binary operations:\n");
    fprintf(stderr, "  -combine          average the input maps into one\n");
    fprintf(stderr, "  -diff             subtract: map1 - map2\n");
    fprintf(stderr, "  -mult             multiply: map1 * map2\n");
    fprintf(stderr, "options:\n");
    fprintf(stderr, "  -o <filename>     write output DX map to file\n");
    fprintf(stderr, "operations with a PMF version:\n");
    fprintf(stderr, "  -dspmf, smoothpmf, collapsepmf, combinepmf\n");
    exit(0);
  }
  		
  #define MAXFILES 200
  numinputfiles = 0;
  filelist = (char**) malloc(MAXFILES*sizeof(char*));
  memset(filelist, 0, MAXFILES*sizeof(char*));
  
  // PARSE OPTIONS AND FILES
  for (int i=1; i<argc; i++)
    if (argv[i][0] == '-'){

      if (0); //NECESSARY
      
      SETPARAM_FLAG("exp", "", do_exp)
      SETPARAM_FLAG("log", "", do_log)
                
      SETPARAM_FLAG("downsample", "", do_downsample)
      SETPARAM_FLAG("dspmf", "", do_downsample_pmf)
      SETPARAM_FLAG("ds", "", do_downsample)
          
      SETPARAM_FLAG("collapsepmf", "", do_collapse_pmf)
      SETPARAM_FLAG("collapse", "", do_collapse)
      
      SETPARAM_FLAG("avgrotpmf", "", do_rotate_avg_pmf)
      SETPARAM_FLAG("avgrot", "", do_rotate_avg)
            
      SETPARAM_FLAG("combinepmf", "", do_combinepmf)
      SETPARAM_FLAG("combine", "", do_combine)
      SETPARAM_FLAG("mult", "", do_mult)
      SETPARAM_FLAG("add", "", do_sum)
      SETPARAM_FLAG("diff", "", do_diff)
      SETPARAM_FLAG("count", "", do_occup)


      SETPARAM_LONG("trimxp", trimxp)
      SETPARAM_LONG("trimyp", trimyp)
      SETPARAM_LONG("trimzp", trimzp)
      SETPARAM_LONG("trimxm", trimxm)
      SETPARAM_LONG("trimym", trimym)
      SETPARAM_LONG("trimzm", trimzm)
                
      SETPARAM_LONG("trimx", trimx)
      SETPARAM_LONG("trimy", trimy)
      SETPARAM_LONG("trimz", trimz)
      SETPARAM_LONG("trim", trim)
      
      SETPARAM_FLAG("custom1", "", do_custom1)
      SETPARAM_FLAG("custom2", "", do_custom2)
      
      SETPARAM_DOUBLE("smoothpmf", smooth_radius_pmf)
      SETPARAM_DOUBLE("smooth", smooth_radius)

                  
      SETPARAM_STRING("o",outputname)
            		
      else {
        fprintf(stderr, "Unknown parameter: %s\n", argv[i]);
        exit(1);
      }
    }
    else {
      if (numinputfiles < MAXFILES) {
        filelist[numinputfiles] = argv[i];
        numinputfiles++;
      } 
      else err_too_many_inputs = true;
      
      if (!inputname1) inputname1 = argv[i];
      else if (!inputname2) inputname2 = argv[i];
    }

  //post-processing
  if (!inputname1) {
    fprintf(stderr, "No input files given!\n");
    exit(1);
  }	else {
    printf("INPUT 1: %s\n", inputname1);
  }
 
  if (do_diff) need_two_inputs = true;
  if (need_two_inputs && !inputname2) {
    fprintf(stderr, "The operations requested require 2 input files!\n");
    exit(1);
  }
  else if (need_two_inputs) {
    printf("INPUT 2: %s\n", inputname2);
  }
    
  if (err_too_many_inputs || (numinputfiles > 2 && !do_combinepmf && !do_combine)) {
    fprintf(stderr, "Too many input files given (max allowed: 2)!\n");
    exit(1);
  }
  
  if (trim < 0) trim = 0;
  if (trimx < 0) trimx = trim;
  if (trimy < 0) trimy = trim;
  if (trimz < 0) trimz = trim;
  if (trimxp < 0) trimxp = trimx;
  if (trimyp < 0) trimyp = trimy;
  if (trimzp < 0) trimzp = trimz;
  if (trimxm < 0) trimxm = trimx;
  if (trimym < 0) trimym = trimy;
  if (trimzm < 0) trimzm = trimz;
  if (trimxp>0 || trimxm>0 || trimyp>0 || trimym>0 || trimzp>0 || trimzm>0) do_trim = true;
}


