
// Written by Jordi Cohen, 2005-2006
// Theoretical and Computational Biophysics Group
// University of Illinois, Urbana, IL


#include <stdio.h>
#include <stdlib.h>

#include "params.h"
#include "volmap.h"

int main(int argc, char** argv) {
  int err;
  
  printf("volutil 1.0 by Jordi Cohen\n");
      
  ScanCommandLine(argc, argv);
  
  VolMap *pot = new VolMap();
  pot->refname = "OUTPUT";

  if (do_combine) {
    pot->create_combine(filelist, numinputfiles);
  }
  else if (do_combinepmf) {
    pot->create_combine(filelist, numinputfiles, PMF);
  }
  else if (inputname2) {
    VolMap *pot1 = new VolMap();
    pot1->refname = "INPUT 1";
    err = pot1->read_dx_file(inputname1);
    if (err) exit(1);
    
    VolMap *pot2 = new VolMap();
    pot2->refname = "INPUT 2";
    err = pot2->read_dx_file(inputname2);
    if (err) exit(1);
    
    else if (do_mult) pot->create_multiply(pot1, pot2);
    else if (do_sum) pot->create_sum(pot1, pot2);
    if (do_diff) pot->create_diff(pot1, pot2);
    
    delete pot1;
    delete pot2;
  }
  else {
    err = pot->read_dx_file(inputname1);
    if (err) exit(1);
  }

  if (do_rotate_avg) pot->average_over_rotations();
  else if (do_rotate_avg_pmf) pot->average_over_rotations(PMF);
  
  if (do_trim) pot->trim(trimxm, trimxp, trimym, trimyp, trimzm, trimzp);
  
  if (do_downsample) pot->downsample();
  else if (do_downsample_pmf) pot->downsample(PMF);
  
  if (do_collapse) pot->collapse_onto_z();
  else if (do_collapse_pmf) pot->collapse_onto_z(PMF);

  if (smooth_radius) pot->smooth(smooth_radius);
  else if (smooth_radius_pmf) pot->smooth(smooth_radius_pmf, PMF);
      
  if (do_exp) pot->convert_pmf_to_density();
  if (do_log) pot->convert_density_to_pmf();
  pot->print_stats();
  
  if (do_occup) pot->total_occupancy();

  
  if (outputname) pot->write_dx_file(outputname);
  else printf("No output produced.\n");

  delete pot;
  
  return 0;
}
