extern const double kNAN;

// Vector utilities

inline void vset(double *vout, double x, double y, double z) {
  vout[0] = x;
  vout[1] = y;
  vout[2] = z;
}

inline void vset(float *vout, float x, float y, float z) {
  vout[0] = x;
  vout[1] = y;
  vout[2] = z;
}

void vcopy(double *vout, const double *v1);
void  vcopy(float *vout, const float *v1);

double vnorm(const double *vec);
float  vnorm(const float *vec);

inline void vscale(double *vout, double ff) {
  vout[0] *= ff;
  vout[1] *= ff;
  vout[2] *= ff;
}

inline void vscale(float *vout, float ff) {
  vout[0] *= ff;
  vout[1] *= ff;
  vout[2] *= ff;
}

inline void vsub(double *vout, const double* v1, const double *v2) {
  vout[0] = v1[0] - v2[0];
  vout[1] = v1[1] - v2[1];
  vout[2] = v1[2] - v2[2];
}

inline void vsub(float *vout, const float* v1, const float *v2) {
  vout[0] = v1[0] - v2[0];
  vout[1] = v1[1] - v2[1];
  vout[2] = v1[2] - v2[2];
}


inline void vcross(double *vout, const double* v1, const double *v2) {
  vout[0] = v1[1]*v2[2] - v1[2]*v2[1];
  vout[1] = v1[0]*v2[2] - v1[2]*v2[0];
  vout[2] = v1[0]*v2[1] - v1[1]*v2[0];
}


inline void vcross(float *vout, const float* v1, const float *v2) {
  vout[0] = v1[1]*v2[2] - v1[2]*v2[1];
  vout[1] = v1[0]*v2[2] - v1[2]*v2[0];
  vout[2] = v1[0]*v2[1] - v1[1]*v2[0];
}


inline double vdot(double* v1, double *v2) {
  return (v1[0]*v2[0] + v1[1]*v2[1] + v1[2]*v2[2]);
}

inline float vdot(float* v1, float *v2) {
  return (v1[0]*v2[0] + v1[1]*v2[1] + v1[2]*v2[2]);
}


inline void vaddscaledto(double *vout, double ff, double *v1) {
  vout[0] += ff*v1[0];
  vout[1] += ff*v1[1];
  vout[2] += ff*v1[2];
}

inline void vaddscaledto(float *vout, float ff, float *v1) {
  vout[0] += ff*v1[0];
  vout[1] += ff*v1[1];
  vout[2] += ff*v1[2];
}



// Useful template operations
template<class T>
inline void swap(T &elem1, T &elem2) {
  T tmp;
  tmp = elem1;
  elem1 = elem2;
  elem2 = tmp;
}

/*template<class T>
inline T max(T elem1, T elem2) {
  if (elem1 >= elem2) return elem1;
  return elem2;
}

template<class T>
inline T min(T elem1, T elem2) {
  if (elem1 <= elem2) return elem1;
  return elem2;
}*/

