# This file shows you how to coimpute an implicit ligand sampling
# PMF map for a given DCD trajectory.

# Edit the all the places denoted as **ALLCAPS** to reflect your own system/setup.

source pmfutils.tcl

# Edit this to be 1,2,3,... if wish to compute separate maps for each trajectroy chunk
set jobnum 1   

# Load coordinates...
set alignmol [mol new ${inputdir}/**ALIGNMENT_TEMPLATE.pdb**]
set molid [mol new ${inputdir}/**PSFFILE.psf**]
PMFUtils::loadfiles ${inputdir}/**EQUILIBRATION-${jobnum}.dcd** -- waitfor all


#Align trajectory to the alignment template, based on alpha carbon locations
PMFUtils::alignmol $molid $alignmol "alpha"
PMFUtils::aligntraj $molid "alpha"

# Load CHARMM 

# This parses a list of CHARMM param files to extract the VDW energy parameters needed 
# for the analysis. Add or substitute your own pramater files, or simply leave the 
# default parameters taken from your VMD distribution
PMFUtils::readcharmmparams $env(CHARMMPARDIR)/par_all27_prot_lipid_na.inp 

# Assign the proper parameters to each atom in your desired molecule
PMFUtils::assigncharmmparams $molid
  
# Run the analysis
volmap ligand [atomselect $molid "all"] -allframes -combine pmf -dx "**OUTPUTFILENAME-${jobnum}.dx**" -dihomo -conf 50 -cutoff 12 -subres 2


if ![info exists env(DISPLAY)] {quit}

