$VERSION = "1.00";
package TCB::System::Misc;
our $VERSION = "1.00";

# -*- Perl -*-
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2004, Tim Skirvin and UIUC Board of Trustees.
# Redistribution terms are below.
###############################################################################

=head1 NAME

TCB::System::Misc - a basic library, written for DBIx::Frame

=head1 SYNOPSIS

  use TCB::System::Misc;

See the individual table information and TCB::System documentation to see
how this works.

=head1 DESCRIPTION

TCB::System::Misc is a set of tables for TCB::System that are used for
other tables within TCB::System, but are not very handy on their own.  
Specific tables:

=over 4

=item TCB::System::Building - buildings used by the TCB Group

=item TCB::System::OS  - operating systems used in the TCB Group

=item TCB::System::Room - all rooms in use by the TCB Group

=item TCB::System::UsrLocal  - /usr/local trees 

=back

See each table's documentation for more information.

=cut

use strict;
use vars qw( @MODS $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG @ISA @PROBS );
use TCB::System;

### USER VARIABLES ############################################################
@MODS     = qw( DBIx::Frame Exporter TCB::System::OS TCB::System::UsrLocal 
		TCB::System::Room TCB::System::Building );
@ISA      = qw( DBIx::Frame Exporter TCB::System );
$SERVER   = "db.ks.uiuc.edu";	  
$DATABASE = "System";
$DBTYPE	  = "mysql";
$USER     = "guest";
$PASS     = "";
$DEBUG    = 0;
###############################################################################

###############################################################################
### main () ###################################################################
###############################################################################
# Load the necessary modules from @MODS
foreach (@MODS) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if @PROBS;

# Initialize DBIx::Frame
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);
###############################################################################

1;

=head1 NOTES

These tables are essentially helper tables for the rest of TCB::System.
Therefore, see that page for more information on the database as a while.

=head1 REQUIREMENTS

Perl 5.6.0 or better, MySQL, C<DBIx::Frame>, B<TCB::System>

=head1 SEE ALSO

B<DBIx::Frame>, B<TCB::System>, [...], B<TCB::System::OS>,
B<TCB::System::UsrLocal>, B<TCB::System::Room>, B<TCB::System::Building>, 

B<TCB::System::Obsolete>

=head1 TODO

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-system>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-system/license.html> for
details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.2		Mon Oct 13 13:42:41 CDT 2003 
### Setting up for real DBI::Frame.
# v0.95		Mon May 10 16:48:34 CDT 2004 
### Getting ready to use DBIx::Frame instead of DBI::Frame; this is a good
### excuse to comment everything and just generally make it all work.
### Comments are still based on old TCB::Library code, however.
# v1.00		Thu May 13 17:47:30 CDT 2004 
### v1.0 release.
