$VERSION = "1.00";
package TCB::System::All;
our $VERSION = "1.00";

# -*- Perl -*-		Thu May 13 17:39:10 CDT 2004 	
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2004, Tim Skirvin and UIUC Board of Trustees.
# Redistribution terms are below.
###############################################################################

=head1 NAME

TCB::System::All - all current TCB System Databases

=head1 SYNOPSIS

  use TCB::System::All;

See the individual table information and TCB::System documentation to see
how this works.

=head1 DESCRIPTION

TCB::System::All loads all existing tables for TCB::System.  Specifically,
it loads the tables from:

=over 4

=item TCB::Equipment - Equipment Database

=item TCB::Help - Help Database

=item TCB::Loan - Loans

=item TCB::PortMap - Port Map

=item TCB::SysLoads - System Loads

=item TCB::System::Misc - Miscellaneous Tables
		
=item TCB::System::Obsolete - Obsolete Tables

=item 

=back

See each table's documentation for more information.

=cut

use strict;
use vars qw( @MODS $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG @ISA @PROBS );
use TCB::System;

### USER VARIABLES ############################################################
@MODS     = qw( DBIx::Frame Exporter TCB::System TCB::SysLoads TCB::Equipment
	 	TCB::Loan TCB::Help TCB::SysLoads TCB::PortMap 
		TCB::System::Obsolete TCB::System::Misc );
@ISA      = qw( DBIx::Frame Exporter TCB::System );
$SERVER   = "db.ks.uiuc.edu";	  
$DATABASE = "System";
$DBTYPE	  = "mysql";
$USER     = "guest";
$PASS     = "";
$DEBUG    = 0;
###############################################################################

###############################################################################
### main () ###################################################################
###############################################################################
# Load the necessary modules from @MODS
foreach (@MODS) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if @PROBS;

# Initialize DBIx::Frame
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);
###############################################################################

1;

=head1 NOTES

=head1 REQUIREMENTS

Perl 5.6.0 or better, MySQL, C<DBIx::Frame>, B<TCB::System>

=head1 SEE ALSO

B<DBIx::Frame>, B<TCB::System>, B<TCB::SysLoads>, B<TCB::Equipment>,
B<TCB::Loan>, B<TCB::Help>, B<TCB::SysLoads>, B<TCB:PortMap>,
B<TCB::System::Obsolete>

=head1 TODO

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-system>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-system/license.html> for
details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v1.0		Thu May 13 17:39:10 CDT 2004 
### Module created.
