$VERSION = "1.00";
package TCB::System;
# -*- Perl -*-		Thu May 13 09:43:51 CDT 2004 
###############################################################################
# Written by Tim Skirvin <tskirvin@ks.uiuc.edu>
# Copyright 2000-2004, Tim Skirvin and UIUC Board of Trustees.
# Redistribution terms are below.
###############################################################################
our $VERSION = "1.00";

=head1 NAME

TCB::System - System Database for the TCB Group, written for DBIx::Frame

=head1 SYNOPSIS

  use TCB::System;

See the included CGI scripts to see how it works.

=head1 DESCRIPTION

TCB::System is a DBIx::Frame object used to track TCB system
administration-related information.  

No specific tables are loaded by just using TCB::System; this is just the
framework to use those tables.  You will have to find more tables to
actually look at any useful information.  

=cut

use strict;
use vars qw( @MODS $SERVER $DATABASE $DBTYPE $USER $PASS $DEBUG @ISA @PROBS );

### USER VARIABLES ############################################################
# @MODS     = qw( DBIx::Frame Exporter TCB::System::Misc );
@MODS     = qw( DBIx::Frame Exporter );
@ISA      = qw( DBIx::Frame Exporter );
$SERVER   = "db.ks.uiuc.edu";	  
$DATABASE = "System";
$DBTYPE	  = "mysql";
$USER     = "guest";
$PASS     = "";
$DEBUG    = 0;
###############################################################################

###############################################################################
### main () ###################################################################
###############################################################################
# Load the necessary modules from @MODS
foreach (@MODS) { local $@; eval "use $_"; push @PROBS, "$@" if $@; }
die @PROBS if @PROBS;

# Initialize DBIx::Frame
DBIx::Frame->init($SERVER, $DBTYPE, $DATABASE, $USER, $PASS, $SERVER);
###############################################################################

1;

=head1 NOTES

These tables were created over years of necessity, and the whole is not a
very well put-together beast.  But it does work for us, and may be useful
for someone else.  

The underlying databases were primarily created by Tim Skirvin
<tskirvin@ks.uiuc.edu> and Charlie Brown (no email address on record).  

=head1 REQUIREMENTS

Perl 5.6.0 or better, MySQL, C<DBIx::Frame>.

=head1 SEE ALSO

B<DBIx::Frame>, B<TCB::Equipment>, B<TCB::Help>, B<TCB::SysLoads>,
B<TCB::System::Obsolete>, B<TCB::System::Misc>, B<TCB::Equipment>,
B<TCB::Loan>, B<TCB::Port>

=head1 TODO

=head1 AUTHOR

Written by Tim Skirvin <tskirvin@ks.uiuc.edu>.

=head1 HOMEPAGE

B<http://www.ks.uiuc.edu/Development/MDTools/tcb-system>

=head1 LICENSE

This code is distributed under the University of Illinois Open Source
License.  See
C<http://www.ks.uiuc.edu/Development/MDTools/tcb-system/license.html> for
details.

=head1 COPYRIGHT

Copyright 2000-2004 by the University of Illinois Board of Trustees and
Tim Skirvin <tskirvin@ks.uiuc.edu>.

=cut

###############################################################################
### Version History ###########################################################
###############################################################################
# v0.2		Mon Oct 13 13:42:41 CDT 2003 
### Setting up for real DBI::Frame.
# v0.95		Mon May 10 16:48:34 CDT 2004 
### Getting ready to use DBIx::Frame instead of DBI::Frame; this is a good
### excuse to comment everything and just generally make it all work.
# v1.00		Thu May 13 09:43:35 CDT 2004 
### Packaging up and distributing.
